/*
 * Decompiled with CFR 0.152.
 */
package net.cyvforge.util.parkour;

import java.text.DecimalFormat;
import net.cyvforge.CyvForge;
import net.cyvforge.config.CyvClientConfig;
import net.cyvforge.event.events.ParkourTickListener;
import net.cyvforge.util.parkour.LandingAxis;
import net.cyvforge.util.parkour.LandingBlock;
import net.cyvforge.util.parkour.LandingMode;
import net.minecraft.client.Minecraft;
import net.minecraft.util.AxisAlignedBB;

public class LandingBlockOffset {
    private static Double currentPb;
    private static Double currentXOffset;
    private static Double currentZOffset;
    private static boolean sendChatOffset;

    public static void refreshPb() {
        currentPb = null;
        currentXOffset = null;
        currentZOffset = null;
        sendChatOffset = false;
    }

    public static void check(double x, double y, double z, double lastx, double lasty, double lastz, LandingBlock b, int i) {
        Double xOffset = null;
        Double zOffset = null;
        Double eventX = null;
        Double eventZ = null;
        if (y < b.bb[i].field_72338_b) {
            return;
        }
        if (y < b.bb[i].field_72337_e && b.mode.equals((Object)LandingMode.enter)) {
            xOffset = LandingBlockOffset.checkX(x, b, i);
            zOffset = LandingBlockOffset.checkZ(z, b, i);
            eventX = x;
            eventZ = z;
        } else if (y <= b.bb[i].field_72337_e && b.mode.equals((Object)LandingMode.hit) && lasty >= b.bb[i].field_72337_e) {
            xOffset = LandingBlockOffset.checkX(x, b, i);
            zOffset = LandingBlockOffset.checkZ(z, b, i);
            eventX = x;
            eventZ = z;
        } else if (y >= b.bb[i].field_72337_e && (b.mode.equals((Object)LandingMode.z_neo) || b.mode.equals((Object)LandingMode.landing))) {
            xOffset = LandingBlockOffset.checkX(x, b, i);
            eventX = x;
            if (b.mode.equals((Object)LandingMode.z_neo)) {
                zOffset = LandingBlockOffset.checkZ(lastz, b, i);
                eventZ = lastz;
                if (b.neoAndNormal) {
                    double temp = LandingBlockOffset.checkZ(z, b, i);
                    zOffset = temp < zOffset ? temp : zOffset;
                    eventZ = z;
                }
            } else {
                zOffset = LandingBlockOffset.checkZ(z, b, i);
                eventZ = z;
            }
        }
        if (!(eventX != null && eventZ != null && eventX <= b.xMaxCond && eventX >= b.xMinCond && eventZ <= b.zMaxCond && eventZ >= b.zMinCond)) {
            return;
        }
        AxisAlignedBB playerBB = Minecraft.func_71410_x().field_71439_g.func_174813_aQ();
        double playerLengthX = playerBB.field_72336_d - playerBB.field_72340_a;
        double playerLengthZ = playerBB.field_72334_f - playerBB.field_72339_c;
        double pb = LandingBlockOffset.calculatePb(xOffset, zOffset, b);
        if (currentPb == null) {
            currentPb = pb;
            currentXOffset = xOffset;
            currentZOffset = zOffset;
            sendChatOffset = (CyvClientConfig.getBoolean("sendLbChatOffset", false) && b == ParkourTickListener.landingBlock || CyvClientConfig.getBoolean("sendMmChatOffset", false) && b == ParkourTickListener.momentumBlock) && eventX <= b.xMaxCond + playerLengthX / 2.0 && eventX >= b.xMinCond - playerLengthX / 2.0 && eventZ <= b.zMaxCond + playerLengthZ / 2.0 && eventZ >= b.zMinCond - playerLengthZ / 2.0;
        } else if (pb > currentPb) {
            currentPb = pb;
            currentXOffset = xOffset;
            currentZOffset = zOffset;
            sendChatOffset = (CyvClientConfig.getBoolean("sendLbChatOffset", false) && b == ParkourTickListener.landingBlock || CyvClientConfig.getBoolean("sendMmChatOffset", false) && b == ParkourTickListener.momentumBlock) && eventX <= b.xMaxCond + playerLengthX / 2.0 && eventX >= b.xMinCond - playerLengthX / 2.0 && eventZ <= b.zMaxCond + playerLengthZ / 2.0 && eventZ >= b.zMinCond - playerLengthZ / 2.0;
        }
    }

    public static Double checkX(double x, LandingBlock b, int i) {
        double right;
        double left;
        double leftWallOffset;
        AxisAlignedBB playerBB = Minecraft.func_71410_x().field_71439_g.func_174813_aQ();
        double halfPlayerSize = (playerBB.field_72336_d - playerBB.field_72340_a) / 2.0;
        double rightWallOffset = b.xMinWall == null ? 0.0 : b.bb[i].field_72340_a - b.xMinWall - halfPlayerSize * 2.0;
        double d = leftWallOffset = b.xMaxWall == null ? 0.0 : b.xMaxWall - b.bb[i].field_72336_d - halfPlayerSize * 2.0;
        if (rightWallOffset > 0.0) {
            rightWallOffset = 0.0;
        }
        if (leftWallOffset > 0.0) {
            leftWallOffset = 0.0;
        }
        if ((left = b.bb[i].field_72336_d + leftWallOffset - x + halfPlayerSize) > Math.abs(right = x - (b.bb[i].field_72340_a - rightWallOffset) + halfPlayerSize)) {
            return right;
        }
        if (right > Math.abs(left)) {
            return left;
        }
        return Math.max(left, right);
    }

    public static Double checkZ(double z, LandingBlock b, int i) {
        double back;
        double front;
        double frontWallOffset;
        AxisAlignedBB playerBB = Minecraft.func_71410_x().field_71439_g.func_174813_aQ();
        double halfPlayerSize = (playerBB.field_72334_f - playerBB.field_72339_c) / 2.0;
        double backWallOffset = b.zMinWall == null ? 0.0 : b.bb[i].field_72339_c - b.zMinWall - halfPlayerSize * 2.0;
        double d = frontWallOffset = b.zMaxWall == null ? 0.0 : b.zMaxWall - b.bb[i].field_72334_f - halfPlayerSize * 2.0;
        if (backWallOffset > 0.0) {
            backWallOffset = 0.0;
        }
        if (frontWallOffset > 0.0) {
            frontWallOffset = 0.0;
        }
        if ((front = b.bb[i].field_72334_f + frontWallOffset - z + halfPlayerSize) > Math.abs(back = z - (b.bb[i].field_72339_c - backWallOffset) + halfPlayerSize)) {
            return back;
        }
        if (back > Math.abs(front)) {
            return front;
        }
        return Math.max(front, back);
    }

    public static Double calculatePb(Double x, Double z, LandingBlock b) {
        if (x == null) {
            return z;
        }
        if (z == null) {
            return x;
        }
        if (b.axis.equals((Object)LandingAxis.x)) {
            return x;
        }
        if (b.axis.equals((Object)LandingAxis.z)) {
            return z;
        }
        if (x < 0.0 && z < 0.0) {
            return -Math.hypot(x, z);
        }
        if (x < 0.0) {
            return x;
        }
        if (z < 0.0) {
            return z;
        }
        return Math.hypot(x, z);
    }

    public static void finalizePb(LandingBlock b) {
        if (currentPb == null) {
            return;
        }
        Double tempLastPb = b.lastPb;
        boolean momentumCancel = CyvClientConfig.getBoolean("momentumPbCancelling", false) && ParkourTickListener.momentumBlock != null && ParkourTickListener.momentumBlock.lastPb != null && ParkourTickListener.momentumBlock.lastPb < 0.0;
        b.lastPb = currentPb;
        if (b.lastPb != null) {
            if (currentXOffset != null) {
                b.lastOffsetX = currentXOffset;
            }
            if (currentZOffset != null) {
                b.lastOffsetZ = currentZOffset;
            }
            if ((b.pb == null || b.lastPb > b.pb) && b == ParkourTickListener.landingBlock && !momentumCancel) {
                b.pb = b.lastPb;
                b.pbX = currentXOffset;
                b.pbZ = currentZOffset;
                DecimalFormat df = CyvForge.df;
                CyvForge.sendChatMessage("New pb! " + df.format(b.pb));
            }
        }
        if (sendChatOffset && !momentumCancel) {
            if (currentXOffset != null && b.axis != LandingAxis.z) {
                CyvForge.sendChatMessage("X Offset: " + CyvForge.df.format(currentXOffset));
            }
            if (currentZOffset != null && b.axis != LandingAxis.x) {
                CyvForge.sendChatMessage("Z Offset: " + CyvForge.df.format(currentZOffset));
            }
        }
    }

    static {
        sendChatOffset = true;
    }
}

