/*
 * Decompiled with CFR 0.152.
 */
package net.cyvfabric.util.parkour;

import java.util.ArrayList;
import net.cyvfabric.util.parkour.LandingAxis;
import net.cyvfabric.util.parkour.LandingMode;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2399;
import net.minecraft.class_2541;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class LandingBlock {
    public class_2338 pos;
    public class_238[] bb;
    public LandingMode mode;
    public LandingAxis axis;
    public boolean isBox;
    public boolean neoAndNormal;
    public Double pb;
    public Double pbX;
    public Double pbZ;
    public Double lastOffsetX;
    public Double lastOffsetZ;
    public Double lastPb;
    public Double xMaxWall;
    public Double xMinWall;
    public Double zMaxWall;
    public Double zMinWall;
    public double xMinCond;
    public double xMaxCond;
    public double zMinCond;
    public double zMaxCond;

    public LandingBlock(class_2338 pos, LandingMode mode, LandingAxis axis, boolean isBox) {
        this.pos = pos;
        this.mode = mode;
        this.axis = axis;
        this.isBox = isBox;
        this.calculateBounds();
        this.calculateWalls();
        this.xMinCond = this.smallestX() - 1.0;
        this.xMaxCond = this.largestX() + 1.0;
        this.zMinCond = this.smallestZ() - 1.0;
        this.zMaxCond = this.largestZ() + 1.0;
    }

    public LandingBlock(class_238 bounds) {
        this.pos = class_2338.method_49637((double)bounds.field_1323, (double)bounds.field_1322, (double)bounds.field_1321);
        this.mode = LandingMode.landing;
        this.axis = LandingAxis.both;
        this.isBox = false;
        this.bb = new class_238[]{bounds};
        this.xMinCond = this.smallestX() - 1.0;
        this.xMaxCond = this.largestX() + 1.0;
        this.zMinCond = this.smallestZ() - 1.0;
        this.zMaxCond = this.largestZ() + 1.0;
    }

    private void calculateBounds() {
        if (this.pos == null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_638 world = mc.field_1687;
        class_2680 blockState = world.method_8320(this.pos);
        class_265 collisionBox = blockState.method_26220((class_1922)world, this.pos);
        class_2248 block = blockState.method_26204();
        if (this.isBox && (block instanceof class_2399 || block instanceof class_2541)) {
            double playerX = class_310.method_1551().field_1724.method_5829().method_17939();
            double playerZ = class_310.method_1551().field_1724.method_5829().method_17941();
            class_238 box = new class_238(playerX / 2.0 + (double)this.pos.method_10263(), (double)this.pos.method_10264(), playerZ / 2.0 + (double)this.pos.method_10260(), 1.0 - playerX / 2.0 + (double)this.pos.method_10263(), (double)(1 + this.pos.method_10264()), 1.0 - playerZ / 2.0 + (double)this.pos.method_10260());
            this.bb = new class_238[]{box};
            return;
        }
        class_238[] tempB = (class_238[])collisionBox.method_1090().toArray(class_238[]::new);
        this.bb = new class_238[tempB.length];
        for (int i = 0; i < tempB.length; ++i) {
            this.bb[i] = new class_238(tempB[i].field_1323 + (double)this.pos.method_10263(), tempB[i].field_1322 + (double)this.pos.method_10264(), tempB[i].field_1321 + (double)this.pos.method_10260(), tempB[i].field_1320 + (double)this.pos.method_10263(), tempB[i].field_1325 + (double)this.pos.method_10264(), tempB[i].field_1324 + (double)this.pos.method_10260());
        }
    }

    public double smallestX() {
        Double v = null;
        for (class_238 bb : this.bb) {
            if (v != null && !(v > bb.field_1323)) continue;
            v = bb.field_1323;
        }
        return v;
    }

    public double smallestY() {
        Double v = null;
        for (class_238 bb : this.bb) {
            if (v != null && !(v > bb.field_1322)) continue;
            v = bb.field_1322;
        }
        return v;
    }

    public double smallestZ() {
        Double v = null;
        for (class_238 bb : this.bb) {
            if (v != null && !(v > bb.field_1321)) continue;
            v = bb.field_1321;
        }
        return v;
    }

    public double largestX() {
        Double v = null;
        for (class_238 bb : this.bb) {
            if (v != null && !(v < bb.field_1320)) continue;
            v = bb.field_1320;
        }
        return v;
    }

    public double largestY() {
        Double v = null;
        for (class_238 bb : this.bb) {
            if (v != null && !(v < bb.field_1325)) continue;
            v = bb.field_1325;
        }
        return v;
    }

    public double largestZ() {
        Double v = null;
        for (class_238 bb : this.bb) {
            if (v != null && !(v < bb.field_1324)) continue;
            v = bb.field_1324;
        }
        return v;
    }

    public void adjustCond(double x1, double x2, double z1, double z2) {
        if (x1 > x2) {
            this.xMaxCond = x1;
            this.xMinCond = x2;
        } else {
            this.xMaxCond = x2;
            this.xMinCond = x1;
        }
        if (z1 > z2) {
            this.zMaxCond = z1;
            this.zMinCond = z2;
        } else {
            this.zMaxCond = z2;
            this.zMinCond = z1;
        }
    }

    public void calculateWalls() {
        class_638 world = class_310.method_1551().field_1687;
        class_238 playerHitbox = class_310.method_1551().field_1724.method_5829();
        class_2338 tempPos = this.pos;
        if (this.mode == LandingMode.enter) {
            tempPos = tempPos.method_10074();
        }
        this.xMinWall = null;
        this.xMaxWall = null;
        this.zMinWall = null;
        this.zMaxWall = null;
        for (class_238 box : this.bb) {
            double currentWall;
            double offset;
            ArrayList wallBoxes = new ArrayList();
            class_2338 currentWallPos = null;
            currentWallPos = tempPos.method_10095();
            for (double i = 0.0; i < playerHitbox.method_17940(); i += 1.0) {
                currentWallPos = currentWallPos.method_10084();
                wallBoxes.addAll(world.method_8320(currentWallPos).method_26220((class_1922)world, currentWallPos).method_1090());
            }
            for (class_238 wall : wallBoxes) {
                if (wall.method_17939() < box.method_17939() || !((offset = box.field_1321 - (currentWall = wall.field_1324 + (double)currentWallPos.method_10260()) - playerHitbox.method_17941()) < 0.0) || this.zMinWall != null && !(currentWall > this.zMinWall)) continue;
                this.zMinWall = currentWall;
            }
            wallBoxes.clear();
            currentWallPos = tempPos.method_10072();
            for (double i = 0.0; i < playerHitbox.method_17940(); i += 1.0) {
                currentWallPos = currentWallPos.method_10084();
                wallBoxes.addAll(world.method_8320(currentWallPos).method_26220((class_1922)world, currentWallPos).method_1090());
            }
            for (class_238 wall : wallBoxes) {
                if (wall.method_17939() < box.method_17939() || !((offset = (currentWall = wall.field_1321 + (double)currentWallPos.method_10260()) - box.field_1324 - playerHitbox.method_17941()) < 0.0) || this.zMaxWall != null && !(currentWall > this.zMaxWall)) continue;
                this.zMaxWall = currentWall;
            }
            wallBoxes.clear();
            currentWallPos = tempPos.method_10067();
            for (double i = 0.0; i < playerHitbox.method_17940(); i += 1.0) {
                currentWallPos = currentWallPos.method_10084();
                wallBoxes.addAll(world.method_8320(currentWallPos).method_26220((class_1922)world, currentWallPos).method_1090());
            }
            for (class_238 wall : wallBoxes) {
                if (wall.method_17941() < box.method_17941() || !((offset = box.field_1323 - (currentWall = wall.field_1320 + (double)currentWallPos.method_10263()) - playerHitbox.method_17939()) < 0.0) || this.xMinWall != null && !(currentWall > this.xMinWall)) continue;
                this.xMinWall = currentWall;
            }
            wallBoxes.clear();
            currentWallPos = tempPos.method_10078();
            for (double i = 0.0; i < playerHitbox.method_17940(); i += 1.0) {
                currentWallPos = currentWallPos.method_10084();
                wallBoxes.addAll(world.method_8320(currentWallPos).method_26220((class_1922)world, currentWallPos).method_1090());
            }
            for (class_238 wall : wallBoxes) {
                if (wall.method_17941() < box.method_17941() || !((offset = (currentWall = wall.field_1323 + (double)currentWallPos.method_10263()) - box.field_1320 - playerHitbox.method_17939()) < 0.0) || this.xMaxWall != null && !(currentWall > this.xMaxWall)) continue;
                this.xMaxWall = currentWall;
            }
        }
    }
}

