/*
 * Decompiled with CFR 0.152.
 */
package mcpk.functions;

import java.util.ArrayList;
import java.util.HashMap;
import mcpk.Player;
import mcpk.utils.Arguments;
import mcpk.utils.ParserException;

public abstract class Function {
    public abstract String[] names();

    public abstract void run(Player var1, int var2, float var3, ArrayList<Character> var4, HashMap<String, Double> var5) throws DurationException, InvalidKeypressException;

    protected static void checkModifiers(ArrayList<Character> modifiers, Arguments args, int duration) throws DurationException {
        if (!modifiers.isEmpty()) {
            if (duration < 0) {
                throw new DurationException();
            }
            if (!modifiers.contains(Character.valueOf('w'))) {
                if (modifiers.contains(Character.valueOf('s'))) {
                    args.replace("forward", -1);
                } else {
                    args.replace("forward", 0);
                }
            }
            if (modifiers.contains(Character.valueOf('w')) && modifiers.contains(Character.valueOf('s'))) {
                args.replace("forward", 0);
            }
            if (modifiers.contains(Character.valueOf('a')) && modifiers.contains(Character.valueOf('d'))) {
                args.replace("strafing", 0);
            } else if (modifiers.contains(Character.valueOf('a'))) {
                args.replace("strafing", 1);
            } else if (modifiers.contains(Character.valueOf('d'))) {
                args.replace("strafing", -1);
            }
        }
    }

    protected static void checkNoModifiers(ArrayList<Character> modifiers) throws InvalidKeypressException {
        if (!modifiers.isEmpty()) {
            throw new InvalidKeypressException();
        }
    }

    protected static void checkEffects(HashMap<String, Double> effects, Arguments args, int duration) {
        if (effects.containsKey("slip")) {
            args.replace("slip", effects.get("slip"));
        }
        if (effects.containsKey("blocking")) {
            args.replace("blocking", effects.get("blocking"));
        }
        if (effects.containsKey("swiftness")) {
            args.replace("swiftness", effects.get("swiftness"));
        }
        if (effects.containsKey("slowness")) {
            args.replace("slowness", effects.get("slowness"));
        }
    }

    public static class DurationException
    extends ParserException {
        public DurationException() {
            super("Duration cannot be negative when key modifiers are present.");
        }
    }

    public static class InvalidKeypressException
    extends ParserException {
        public InvalidKeypressException() {
            super("This function does not allow key modifiers.");
        }
    }
}

