/*
 * Decompiled with CFR 0.152.
 */
package net.cyvfabric.command.calculations;

import com.mojang.brigadier.context.CommandContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.cyvfabric.CyvFabric;
import net.cyvfabric.util.CyvCommand;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;

public class CommandCalculate
extends CyvCommand {
    public CommandCalculate() {
        super("calculate");
        this.hasArgs = true;
        this.usage = "<math expression>";
        this.helpString = "Parse a string for a math expression to evaluate.";
        this.aliases.add("calc");
        this.aliases.add("==");
        this.aliases.add("=");
    }

    @Override
    public void run(CommandContext<FabricClientCommandSource> context, String[] args) {
        if (args.length == 0) {
            CyvFabric.sendChatMessage("Please input something to calculate.");
        } else {
            String text = String.join((CharSequence)" ", args);
            new Calculator(text).start();
        }
    }

    static class Calculator
    extends Thread {
        String input;

        Calculator(String args) {
            this.input = args;
        }

        @Override
        public void run() {
            try {
                double result = this.parse(this.separate(this.input), true);
                DecimalFormat df = CyvFabric.df;
                CyvFabric.sendChatMessage("Calculating " + this.input + "\n = " + df.format(result));
            }
            catch (Exception e) {
                CyvFabric.sendChatMessage("Calculation failed.");
            }
        }

        public ArrayList<String> separate(String input) throws Exception {
            input = input.toLowerCase();
            ArrayList<String> elements = new ArrayList<String>();
            int state = 0;
            Object current_number = "";
            Object current_function = "";
            ArrayList<Character> operands = new ArrayList<Character>();
            operands.add(Character.valueOf('+'));
            operands.add(Character.valueOf('-'));
            operands.add(Character.valueOf('*'));
            operands.add(Character.valueOf('/'));
            operands.add(Character.valueOf('^'));
            ArrayList<String> advFunctions = new ArrayList<String>();
            advFunctions.add("sin(");
            advFunctions.add("cos(");
            advFunctions.add("tan(");
            advFunctions.add("sec(");
            advFunctions.add("csc(");
            advFunctions.add("cot(");
            advFunctions.add("asin(");
            advFunctions.add("acos(");
            advFunctions.add("atan(");
            advFunctions.add("asec(");
            advFunctions.add("acsc(");
            advFunctions.add("acot(");
            advFunctions.add("arcsin(");
            advFunctions.add("arccos(");
            advFunctions.add("arctan(");
            advFunctions.add("arcsec(");
            advFunctions.add("arccsc(");
            advFunctions.add("arccot(");
            advFunctions.add("log(");
            advFunctions.add("ln(");
            advFunctions.add("abs(");
            advFunctions.add("sqrt(");
            advFunctions.add("cbrt(");
            for (int i = 0; i < input.length(); ++i) {
                char current = input.charAt(i);
                if (state == 0) {
                    block91: {
                        char last_value;
                        if (Character.isDigit(current) || current == '.') {
                            block89: {
                                if (elements.size() != 0) {
                                    String last_value2 = elements.get(elements.size() - 1);
                                    try {
                                        Double.parseDouble(last_value2);
                                        elements.add("*");
                                    }
                                    catch (Exception e) {
                                        if (!last_value2.equals(")")) break block89;
                                        elements.add("*");
                                    }
                                }
                            }
                            current_number = (String)current_number + current;
                            state = 1;
                            continue;
                        }
                        if (current == ' ') continue;
                        if (current == '!') {
                            last_value = elements.get(elements.size() - 1).toCharArray()[0];
                            if (operands.contains(Character.valueOf(last_value))) {
                                throw new Exception("Factorial must be of a number");
                            }
                            elements.add("!");
                            continue;
                        }
                        if (operands.contains(Character.valueOf(current))) {
                            if (elements.size() != 0) {
                                last_value = elements.get(elements.size() - 1).toCharArray()[0];
                                if (last_value == '(') {
                                    if (current != '-') {
                                        throw new Exception("Started with operand");
                                    }
                                    current_number = (String)current_number + current;
                                    state = 1;
                                    continue;
                                }
                                if (operands.contains(Character.valueOf(last_value))) {
                                    if (current != '-') {
                                        throw new Exception("Two operands in a row");
                                    }
                                    current_number = (String)current_number + current;
                                    state = 1;
                                    continue;
                                }
                            } else {
                                if (current != '-') {
                                    throw new Exception("Started with operand");
                                }
                                current_number = (String)current_number + current;
                                state = 1;
                                continue;
                            }
                            elements.add("" + current);
                            state = 0;
                            continue;
                        }
                        if (current == '(') {
                            block90: {
                                if (elements.size() != 0) {
                                    String last_value3 = elements.get(elements.size() - 1);
                                    try {
                                        Double.parseDouble(last_value3);
                                        elements.add("*");
                                    }
                                    catch (Exception e) {
                                        if (!last_value3.equals(")")) break block90;
                                        elements.add("*");
                                    }
                                }
                            }
                            elements.add("(");
                            state = 0;
                            continue;
                        }
                        if (current == ')') {
                            if (elements.size() != 0) {
                                last_value = elements.get(elements.size() - 1).toCharArray()[0];
                                if (operands.contains(Character.valueOf(last_value))) {
                                    throw new Exception("Last element in parenthesis was an operand");
                                }
                            } else {
                                throw new Exception("Started with closing parenthesis");
                            }
                            elements.add(")");
                            state = 0;
                            continue;
                        }
                        if (elements.size() != 0) {
                            String last_value4 = elements.get(elements.size() - 1);
                            try {
                                Double.parseDouble(last_value4);
                                elements.add("*");
                            }
                            catch (Exception e) {
                                if (!last_value4.equals(")")) break block91;
                                elements.add("*");
                            }
                        }
                    }
                    current_function = (String)current_function + current;
                    state = 2;
                    continue;
                }
                if (state == 1) {
                    if (Character.isDigit(current) || current == '.') {
                        if (current == '.' && ((String)current_number).indexOf(46) != -1) {
                            throw new Exception("You can't use two decimal places in one number.");
                        }
                        current_number = (String)current_number + current;
                        continue;
                    }
                    if (current == ' ') {
                        if (((String)current_number).equals("-")) {
                            throw new Exception("Invalid minus sign");
                        }
                        elements.add((String)current_number);
                        current_number = "";
                        state = 0;
                        continue;
                    }
                    if (operands.contains(Character.valueOf(current))) {
                        if (((String)current_number).equals("-")) {
                            throw new Exception("Two operands in a row");
                        }
                        elements.add((String)current_number);
                        current_number = "";
                        elements.add("" + current);
                        state = 0;
                        continue;
                    }
                    if (current == '(') {
                        if (((String)current_number).equals("-")) {
                            current_number = "";
                            elements.add("-(");
                            state = 0;
                            continue;
                        }
                        elements.add((String)current_number);
                        current_number = "";
                        elements.add("*");
                        elements.add("(");
                        state = 0;
                        continue;
                    }
                    if (current == ')') {
                        if (((String)current_number).equals("-")) {
                            throw new Exception("Invalid negative symbol");
                        }
                        elements.add((String)current_number);
                        current_number = "";
                        elements.add(")");
                        state = 0;
                        continue;
                    }
                    if (current == '!') {
                        if (((String)current_number).equals("-")) {
                            throw new Exception("Invalid negative symbol");
                        }
                        elements.add((String)current_number);
                        current_number = "";
                        elements.add("!");
                        state = 0;
                        continue;
                    }
                    if (((String)current_number).equals("-")) {
                        current_function = (String)current_function + (String)current_number + current;
                        current_number = "";
                        state = 2;
                        continue;
                    }
                    elements.add((String)current_number);
                    current_number = "";
                    elements.add("*");
                    current_function = (String)current_function + current;
                    state = 2;
                    continue;
                }
                if (state != 2) continue;
                if (current == ' ') {
                    if (((String)current_function).equals("pi")) {
                        elements.add("3.141592653589793");
                    } else if (((String)current_function).equals("e")) {
                        elements.add("2.718281828459045");
                    } else if (((String)current_function).equals("-pi")) {
                        elements.add("-3.141592653589793");
                    } else if (((String)current_function).equals("-e")) {
                        elements.add("-2.718281828459045");
                    } else {
                        throw new Exception("Invalid special number");
                    }
                    current_function = "";
                    state = 0;
                    continue;
                }
                if (operands.contains(Character.valueOf(current))) {
                    if (((String)current_function).equals("pi")) {
                        elements.add("3.141592653589793");
                    } else if (((String)current_function).equals("e")) {
                        elements.add("2.718281828459045");
                    } else if (((String)current_function).equals("-pi")) {
                        elements.add("-3.141592653589793");
                    } else if (((String)current_function).equals("-e")) {
                        elements.add("-2.718281828459045");
                    } else {
                        throw new Exception("Invalid special number");
                    }
                    elements.add("" + current);
                    current_function = "";
                    state = 0;
                    continue;
                }
                if (current == '!') {
                    if (((String)current_function).equals("pi")) {
                        elements.add("3.141592653589793");
                    } else if (((String)current_function).equals("e")) {
                        elements.add("2.718281828459045");
                    } else if (((String)current_function).equals("-pi")) {
                        elements.add("-3.141592653589793");
                    } else if (((String)current_function).equals("-e")) {
                        elements.add("-2.718281828459045");
                    } else {
                        throw new Exception("Invalid special number");
                    }
                    elements.add("!");
                    current_function = "";
                    state = 0;
                    continue;
                }
                if (current == ')') {
                    if (((String)current_function).equals("pi")) {
                        elements.add("3.141592653589793");
                    } else if (((String)current_function).equals("e")) {
                        elements.add("2.718281828459045");
                    } else if (((String)current_function).equals("-pi")) {
                        elements.add("-3.141592653589793");
                    } else if (((String)current_function).equals("-e")) {
                        elements.add("-2.718281828459045");
                    } else {
                        throw new Exception("Invalid special number");
                    }
                    elements.add(")");
                    current_function = "";
                    state = 0;
                    continue;
                }
                if (current == '(') {
                    if (!advFunctions.contains(current_function = (String)current_function + current) && !advFunctions.contains(((String)current_function).substring(1))) {
                        throw new Exception("Invalid function");
                    }
                    elements.add((String)current_function);
                    current_function = "";
                    state = 0;
                    continue;
                }
                current_function = (String)current_function + current;
            }
            if (state == 1) {
                elements.add((String)current_number);
                current_number = "";
                state = 0;
            }
            if (state == 2) {
                if (((String)current_function).equals("pi")) {
                    elements.add("3.141592653589793");
                } else if (((String)current_function).equals("e")) {
                    elements.add("2.718281828459045");
                } else if (((String)current_function).equals("-pi")) {
                    elements.add("-3.141592653589793");
                } else if (((String)current_function).equals("-e")) {
                    elements.add("-2.718281828459045");
                } else {
                    throw new Exception("Invalid special number");
                }
                current_function = "";
                state = 0;
            }
            return elements;
        }

        public double parse(ArrayList<String> elements, boolean isOriginal) throws Exception {
            String current;
            int i;
            ArrayList<String> advFunctions = new ArrayList<String>();
            advFunctions.add("(");
            advFunctions.add("sin(");
            advFunctions.add("cos(");
            advFunctions.add("tan(");
            advFunctions.add("sec(");
            advFunctions.add("csc(");
            advFunctions.add("cot(");
            advFunctions.add("asin(");
            advFunctions.add("acos(");
            advFunctions.add("atan(");
            advFunctions.add("asec(");
            advFunctions.add("acsc(");
            advFunctions.add("acot(");
            advFunctions.add("arcsin(");
            advFunctions.add("arccos(");
            advFunctions.add("arctan(");
            advFunctions.add("arcsec(");
            advFunctions.add("arccsc(");
            advFunctions.add("arccot(");
            advFunctions.add("log(");
            advFunctions.add("ln(");
            advFunctions.add("abs(");
            advFunctions.add("sqrt(");
            advFunctions.add("cbrt(");
            for (i = 0; i < elements.size(); ++i) {
                current = elements.get(i);
                if (!advFunctions.contains(current) && !advFunctions.contains(current.substring(1))) continue;
                int term_count = 1;
                int starting_index = i;
                ArrayList<String> subElements = new ArrayList<String>();
                String temp = "";
                boolean isSuccessful = true;
                do {
                    ++i;
                    try {
                        temp = elements.get(i);
                    }
                    catch (Exception e) {
                        throw new Exception("Unbalanced Parenthesis");
                    }
                    if (advFunctions.contains(temp) || advFunctions.contains(temp.substring(1))) {
                        ++term_count;
                        isSuccessful = false;
                        break;
                    }
                    if (!temp.equals(")")) {
                        subElements.add(temp);
                    }
                    ++term_count;
                } while (!temp.equals(")") && i < elements.size());
                if (i == elements.size()) {
                    throw new Exception("Unbalanced parenthesis");
                }
                if (!isSuccessful) {
                    --i;
                    continue;
                }
                String a = elements.get(starting_index);
                if (elements.get(starting_index).charAt(0) == '-') {
                    a = a.substring(1);
                }
                double value = this.parse(subElements, false);
                if (a.equals("sin(")) {
                    value = Math.sin(value);
                } else if (a.equals("cos(")) {
                    value = Math.cos(value);
                } else if (a.equals("tan(")) {
                    value = Math.tan(value);
                } else if (a.equals("sec(")) {
                    value = 1.0 / Math.cos(value);
                } else if (a.equals("csc(")) {
                    value = 1.0 / Math.sin(value);
                } else if (a.equals("cot(")) {
                    value = 1.0 / Math.tan(value);
                } else if (a.equals("asin(") || a.equals("arcsin(")) {
                    value = Math.asin(value);
                } else if (a.equals("acos(") || a.equals("arccos(")) {
                    value = Math.acos(value);
                } else if (a.equals("atan(") || a.equals("arctan(")) {
                    value = Math.atan(value);
                } else if (a.equals("acsc(") || a.equals("arccsc(")) {
                    value = Math.asin(1.0 / value);
                } else if (a.equals("asec(") || a.equals("arcsec(")) {
                    value = Math.acos(1.0 / value);
                } else if (a.equals("acot(") || a.equals("arccot(")) {
                    value = Math.atan(1.0 / value);
                } else if (a.equals("log(")) {
                    value = Math.log(value) / Math.log(10.0);
                } else if (a.equals("ln(")) {
                    value = Math.log(value);
                } else if (a.equals("abs(")) {
                    value = Math.abs(value);
                } else if (a.equals("sqrt(")) {
                    value = Math.sqrt(value);
                } else if (a.equals("cbrt(")) {
                    value = Math.cbrt(value);
                }
                if (elements.get(starting_index).charAt(0) == '-') {
                    value = -value;
                }
                if (a.equals("sin(") || a.equals("cos(") || a.equals("tan(") || a.equals("sec(") || a.equals("csc(") || a.equals("cot(") || a.equals("asin(") || a.equals("acos(") || a.equals("atan(") || a.equals("asec") || a.equals("acsc(") || a.equals("acot(")) {
                    if (value > Math.pow(10.0, 14.0)) {
                        value = Double.POSITIVE_INFINITY;
                    } else if (value < -Math.pow(10.0, 14.0)) {
                        value = Double.NEGATIVE_INFINITY;
                    }
                }
                elements.set(starting_index, "" + value);
                for (int j = 0; j < term_count - 1; ++j) {
                    elements.remove(starting_index + 1);
                }
                i = -1;
            }
            for (i = 0; i < elements.size(); ++i) {
                current = elements.get(i);
                if (!current.equals("!")) continue;
                double term1 = Double.parseDouble(elements.get(i - 1));
                elements.set(i - 1, "" + Calculator.factorial(term1));
                elements.remove(i);
                i = -1;
            }
            for (i = 0; i < elements.size(); ++i) {
                current = elements.get(i);
                if (!current.equals("^")) continue;
                double term1 = Double.parseDouble(elements.get(i - 1));
                double term2 = Double.parseDouble(elements.get(i + 1));
                double value = Math.pow(term1, term2);
                elements.set(i - 1, "" + value);
                elements.remove(i + 1);
                elements.remove(i);
                i = -1;
            }
            for (i = 0; i < elements.size(); ++i) {
                double value;
                double term2;
                double term1;
                current = elements.get(i);
                if (current.equals("*")) {
                    term1 = Double.parseDouble(elements.get(i - 1));
                    term2 = Double.parseDouble(elements.get(i + 1));
                    value = term1 * term2;
                    elements.set(i - 1, "" + value);
                    elements.remove(i + 1);
                    elements.remove(i);
                    i = -1;
                    continue;
                }
                if (!current.equals("/")) continue;
                term1 = Double.parseDouble(elements.get(i - 1));
                term2 = Double.parseDouble(elements.get(i + 1));
                value = term1 / term2;
                elements.set(i - 1, "" + value);
                elements.remove(i + 1);
                elements.remove(i);
                i = -1;
            }
            for (i = 0; i < elements.size(); ++i) {
                double value;
                double term2;
                double term1;
                current = elements.get(i);
                if (current.equals("+")) {
                    term1 = Double.parseDouble(elements.get(i - 1));
                    term2 = Double.parseDouble(elements.get(i + 1));
                    value = term1 + term2;
                    elements.set(i - 1, "" + value);
                    elements.remove(i + 1);
                    elements.remove(i);
                    i = -1;
                    continue;
                }
                if (!current.equals("-")) continue;
                term1 = Double.parseDouble(elements.get(i - 1));
                term2 = Double.parseDouble(elements.get(i + 1));
                value = term1 - term2;
                elements.set(i - 1, "" + value);
                elements.remove(i + 1);
                elements.remove(i);
                i = -1;
            }
            if (elements.get(0).equals("pi")) {
                elements.set(0, "3.141592653589793");
            } else if (elements.get(0).equals("e")) {
                elements.set(0, "2.718281828459045");
            }
            if (Double.isInfinite(Double.parseDouble(elements.get(0)))) {
                return Double.parseDouble(elements.get(0));
            }
            if (isOriginal) {
                double answer = Double.parseDouble(elements.get(0));
                BigDecimal bd = new BigDecimal(Double.toString(answer));
                bd = bd.setScale(10, RoundingMode.HALF_DOWN);
                return bd.doubleValue();
            }
            return Double.parseDouble(elements.get(0));
        }

        public ArrayList<String> smallerList(ArrayList<String> original, int index) {
            ArrayList<String> newList = new ArrayList<String>();
            for (int i = index; i < original.size(); ++i) {
                newList.add(original.get(i));
            }
            return newList;
        }

        static double factorial(double n) throws Exception {
            if (n == 0.0) {
                return 1.0;
            }
            if (n < 0.0) {
                throw new Exception("Factorials only work for positive numbers.");
            }
            if (n != (double)((long)n)) {
                throw new Exception("Factorials only work for whole numbers.");
            }
            double factorial = 1.0;
            int i = 1;
            while ((double)i <= n) {
                factorial *= (double)i;
                ++i;
            }
            return factorial;
        }
    }
}

