/*
 * Decompiled with CFR 0.152.
 */
package net.cyvfabric.event;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import net.cyvfabric.CyvFabric;
import net.cyvfabric.config.ColorTheme;
import net.cyvfabric.config.CyvClientColorHelper;
import net.cyvfabric.config.CyvClientConfig;
import net.cyvfabric.hud.HUDManager;
import net.cyvfabric.hud.structure.DraggableHUDElement;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;

public class ConfigLoader {
    public static final String NAME = "config.txt";
    public static final String PATH = "config/cyvfabric/";
    public static final String FILEPATH = "config/cyvfabric/config.txt";
    public static File configFile;

    public static void init(CyvClientConfig cfg) {
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> ConfigLoader.save(CyvFabric.config, true));
        File dir = new File(PATH);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        dir = new File(PATH);
        configFile = new File(FILEPATH);
        try {
            configFile.createNewFile();
        }
        catch (IOException e) {
            CyvFabric.LOGGER.error(String.valueOf(e));
            return;
        }
        CyvFabric.LOGGER.info("Config file loaded!");
        ConfigLoader.read(cfg);
    }

    public static void read(CyvClientConfig cfg) {
        try {
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(new FileInputStream(configFile)));
            String s = "";
            while ((s = bufferedreader.readLine()) != null) {
                Object[] parts = s.split("=");
                try {
                    if (!cfg.configFields.containsKey(parts[0])) continue;
                    cfg.configFields.get(parts[0]).set(parts[1]);
                }
                catch (Exception e) {
                    CyvFabric.LOGGER.info("Config option \"" + Arrays.toString(parts) + "\" failed to load.");
                }
            }
            bufferedreader.close();
        }
        catch (Exception e) {
            CyvFabric.LOGGER.error(String.valueOf(e));
        }
        CyvClientColorHelper.checkColor(CyvClientConfig.getString("color1", "aqua"), CyvClientConfig.getString("color2", "white"));
        try {
            CyvFabric.theme = ColorTheme.valueOf(CyvClientConfig.getString("theme", "CYVISPIRIA"));
        }
        catch (Exception e) {
            CyvFabric.theme = ColorTheme.CYVISPIRIA;
        }
        for (DraggableHUDElement mod : HUDManager.registeredRenderers) {
            mod.readConfigFields();
        }
        CyvFabric.df.setMinimumIntegerDigits(1);
        if (CyvClientConfig.getBoolean("trimZeroes", true)) {
            CyvFabric.df.setMinimumFractionDigits(0);
        } else {
            CyvFabric.df.setMinimumFractionDigits(CyvClientConfig.getInt("df", 5));
        }
        CyvFabric.df.setMaximumFractionDigits(CyvClientConfig.getInt("df", 5));
        DecimalFormatSymbols s = new DecimalFormatSymbols();
        s.setDecimalSeparator('.');
        CyvFabric.df.setDecimalFormatSymbols(s);
    }

    public static void save(CyvClientConfig cfg, boolean isFinal) {
        for (DraggableHUDElement mod : HUDManager.registeredRenderers) {
            mod.saveConfigFields();
        }
        if (!isFinal) {
            return;
        }
        try {
            FileWriter writer = new FileWriter(configFile, false);
            cfg.configFields.forEach((name, data) -> {
                try {
                    writer.write(name + "=" + data.value.toString() + "\n");
                }
                catch (IOException e) {
                    CyvFabric.LOGGER.error(String.valueOf(e));
                }
            });
            CyvFabric.LOGGER.info("CyvClient config saved!");
            writer.close();
        }
        catch (IOException e) {
            CyvFabric.LOGGER.error(String.valueOf(e));
        }
    }
}

