/*
 * Decompiled with CFR 0.152.
 */
package mcpk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import mcpk.Player;
import mcpk.functions.Function;
import mcpk.functions.nonmovement.SpecialFunction;
import mcpk.utils.ParserException;
import mcpk.utils.ParserFunctions;

public class Parser {
    public float default_facing = 0.0f;
    public HashMap<String, Double> default_effects = new HashMap();
    public ArrayList<Function> functions = ParserFunctions.functionInit();
    public ArrayList<SpecialFunction> specialFunctions = ParserFunctions.specialFunctionInit();

    public void parse(Player player, String text) throws Exception {
        int state = 0;
        Object current_function = "";
        Object current_argument = "";
        Object current_argument_value = "";
        ArrayList<Character> modifiers = new ArrayList<Character>();
        HashMap effects = new HashMap();
        int argument_num = 1;
        double duration = 1.0;
        float facing = this.default_facing;
        Object variable_name = "";
        float variable_value = 0.0f;
        Hashtable<String, Float> variables = new Hashtable<String, Float>();
        player.xCoords.add(player.xOf);
        player.xCoords.add(player.xOf);
        player.zCoords.add(player.zOf);
        player.zCoords.add(player.zOf);
        for (int i = 0; i < text.length(); ++i) {
            boolean bool;
            if (state == 0) {
                if (text.charAt(i) == ' ') continue;
                if (text.charAt(i) == '|') {
                    player.x = 0.0;
                    player.z = 0.0;
                    continue;
                }
                if (text.charAt(i) == 'b') {
                    player.z = player.z < 0.0 ? (player.z -= 0.6) : (player.z += 0.6);
                    if (player.x < 0.0) {
                        player.x -= 0.6;
                        continue;
                    }
                    player.x += 0.6;
                    continue;
                }
                current_function = (String)current_function + text.charAt(i);
                state = 1;
                continue;
            }
            if (state == 1) {
                if (text.charAt(i) == '(') {
                    state = 2;
                    continue;
                }
                if (text.charAt(i) == ' ') {
                    this.run_function(player, (String)current_function, duration, facing, modifiers, effects);
                    modifiers = new ArrayList();
                    effects = (HashMap)this.default_effects.clone();
                    current_argument = "";
                    current_function = "";
                    argument_num = 1;
                    duration = 1.0;
                    facing = this.default_facing;
                    state = 0;
                    continue;
                }
                if (text.charAt(i) == '.') {
                    state = 3;
                    continue;
                }
                current_function = (String)current_function + text.charAt(i);
                continue;
            }
            if (state == 2) {
                if (text.charAt(i) == '(') {
                    throw new ParserException("Error: Unexpected (");
                }
                if (((String)current_function).equals("var") || ((String)current_function).equals("variable")) {
                    if (text.charAt(i) == ' ') {
                        throw new ParserException("Error: Space in variable name");
                    }
                    if (text.charAt(i) == ',') {
                        if (argument_num == 1) {
                            variable_name = current_argument;
                        } else if (argument_num == 2) {
                            variable_value = Float.parseFloat((String)current_argument);
                        }
                        current_argument = "";
                        ++argument_num;
                        continue;
                    }
                    if (text.charAt(i) == ')') {
                        if (text.charAt(i - 1) != ',' && text.charAt(i - 1) != '(') {
                            if (argument_num == 1) {
                                variable_name = current_argument;
                            } else if (argument_num == 2) {
                                variable_value = Float.parseFloat((String)current_argument);
                            }
                        }
                        try {
                            float variable = Float.parseFloat((String)variable_name);
                            throw new ParserException("Error: invalid variable name");
                        }
                        catch (NumberFormatException variable) {
                            if (variables.containsKey(variable_name)) {
                                variables.replace((String)variable_name, Float.valueOf(variable_value));
                            } else {
                                variables.put((String)variable_name, Float.valueOf(variable_value));
                            }
                            current_argument = "";
                            current_function = "";
                            argument_num = 1;
                            state = 0;
                            continue;
                        }
                    }
                    current_argument = (String)current_argument + text.charAt(i);
                    continue;
                }
                if (text.charAt(i) == ' ') continue;
                if (text.charAt(i) == ',') {
                    if (argument_num == 1) {
                        duration = variables.containsKey(current_argument) ? (double)((Float)variables.get(current_argument)).floatValue() : Double.parseDouble((String)current_argument);
                    } else if (argument_num == 2) {
                        facing = variables.containsKey(current_argument) ? ((Float)variables.get(current_argument)).floatValue() : Float.parseFloat((String)current_argument);
                    }
                    current_argument = "";
                    ++argument_num;
                    continue;
                }
                if (text.charAt(i) == ')') {
                    if (text.charAt(i - 1) != ',' && text.charAt(i - 1) != '(') {
                        if (argument_num == 1) {
                            duration = variables.containsKey(current_argument) ? (double)Math.round(((Float)variables.get(current_argument)).floatValue()) : Double.parseDouble((String)current_argument);
                        } else if (argument_num == 2) {
                            facing = variables.containsKey(current_argument) ? ((Float)variables.get(current_argument)).floatValue() : Float.parseFloat((String)current_argument);
                        }
                    }
                    this.run_function(player, (String)current_function, duration, facing, modifiers, effects);
                    modifiers = new ArrayList();
                    effects = (HashMap)this.default_effects.clone();
                    current_argument = "";
                    current_function = "";
                    argument_num = 1;
                    duration = 1.0;
                    facing = this.default_facing;
                    state = 0;
                    continue;
                }
                if (text.charAt(i) == '=') {
                    state = 4;
                    continue;
                }
                current_argument = (String)current_argument + text.charAt(i);
                continue;
            }
            if (state == 3) {
                if (text.charAt(i) == '(') {
                    state = 2;
                    continue;
                }
                if (text.charAt(i) == ' ') {
                    this.run_function(player, (String)current_function, duration, facing, modifiers, effects);
                    modifiers = new ArrayList();
                    effects = (HashMap)this.default_effects.clone();
                    current_argument = "";
                    current_function = "";
                    argument_num = 1;
                    duration = 1.0;
                    facing = this.default_facing;
                    state = 0;
                    continue;
                }
                if (text.charAt(i) == '.') {
                    throw new ParserException("Error: Unexpected .");
                }
                char x = text.charAt(i);
                if (x == 'a' || x == 'd' || x == 'w' || x == 's') {
                    modifiers.add(Character.valueOf(text.charAt(i)));
                    continue;
                }
                throw new ParserException("Error: Invalid modifier.");
            }
            if (state != 4) continue;
            if (text.charAt(i) == ')') {
                if (text.charAt(i - 1) != ',' && text.charAt(i - 1) != '(') {
                    if (variables.containsKey(current_argument_value)) {
                        effects.put(((String)current_argument).toLowerCase(), Double.valueOf(((Float)variables.get(current_argument_value)).floatValue()));
                    } else {
                        try {
                            effects.put(((String)current_argument).toLowerCase(), Double.parseDouble((String)current_argument_value));
                        }
                        catch (Exception e) {
                            bool = Boolean.parseBoolean(((String)current_argument_value).toLowerCase());
                            if (bool) {
                                effects.put(((String)current_argument).toLowerCase(), 1.0);
                            }
                            effects.put(((String)current_argument).toLowerCase(), 0.0);
                        }
                    }
                }
                this.run_function(player, (String)current_function, duration, facing, modifiers, effects);
                modifiers = new ArrayList();
                effects = (HashMap)this.default_effects.clone();
                current_argument = "";
                current_argument_value = "";
                current_function = "";
                argument_num = 1;
                duration = 1.0;
                facing = this.default_facing;
                state = 0;
                continue;
            }
            if (text.charAt(i) == ',') {
                if (text.charAt(i - 1) == ',' || text.charAt(i - 1) == '(') continue;
                if (variables.containsKey(current_argument_value)) {
                    effects.put(((String)current_argument).toLowerCase(), Double.valueOf(((Float)variables.get(current_argument_value)).floatValue()));
                } else {
                    try {
                        effects.put(((String)current_argument).toLowerCase(), Double.parseDouble((String)current_argument_value));
                    }
                    catch (Exception e) {
                        bool = Boolean.parseBoolean(((String)current_argument_value).toLowerCase());
                        if (bool) {
                            effects.put(((String)current_argument).toLowerCase(), 1.0);
                        }
                        effects.put(((String)current_argument).toLowerCase(), 0.0);
                    }
                }
                current_argument = "";
                current_argument_value = "";
                ++argument_num;
                state = 2;
                continue;
            }
            current_argument_value = (String)current_argument_value + text.charAt(i);
        }
        if (state == 1 || state == 3) {
            this.run_function(player, (String)current_function, duration, facing, modifiers, effects);
            modifiers = new ArrayList();
            effects = (HashMap)this.default_effects.clone();
            current_argument = "";
            current_function = "";
            argument_num = 1;
            duration = 1.0;
            facing = this.default_facing;
            state = 0;
        }
        player.finalX = player.xOf;
        player.finalZ = player.zOf;
    }

    void run_function(Player player, String function, double arg1, float facing, ArrayList<Character> modifiers, HashMap<String, Double> effects) throws Exception {
        for (Function function2 : this.functions) {
            for (String name : function2.names()) {
                if (!name.equals(function.toLowerCase())) continue;
                if (arg1 != (double)((int)arg1)) {
                    throw new ParserException("Duration must be an integer.");
                }
                function2.run(player, (int)arg1, facing, modifiers, effects);
                return;
            }
        }
        for (SpecialFunction specialFunction : this.specialFunctions) {
            for (String name : specialFunction.names()) {
                if (!name.equals(function.toLowerCase())) continue;
                specialFunction.specialRun(player, arg1, this);
                return;
            }
        }
        throw new ParserException("Unrecognized function \"" + function + "\"");
    }
}

