/*
 * Decompiled with CFR 0.152.
 */
package net.cyvfabric.command;

import com.mojang.brigadier.context.CommandContext;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import net.cyvfabric.CyvFabric;
import net.cyvfabric.config.CyvClientColorHelper;
import net.cyvfabric.config.CyvClientConfig;
import net.cyvfabric.event.CommandInitializer;
import net.cyvfabric.util.CyvCommand;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;

public class CommandHelp
extends CyvCommand {
    public CommandHelp() {
        super("help");
        this.usage = "[subcommand]";
        this.helpString = "Get the subcommand help menu for the " + String.valueOf(this.parent) + " command.";
    }

    @Override
    public void run(CommandContext<FabricClientCommandSource> context, String[] args) {
        ArrayList<CallSite> helpText;
        ArrayList<CyvCommand> subCommands;
        String commandName;
        Object commandPath;
        if (this.parent == null) {
            commandPath = "/cyv help";
            commandName = "cyv";
            subCommands = CommandInitializer.cyvCommands;
        } else {
            commandPath = "/cyv " + this.parent.name + " help";
            commandName = this.parent.name;
            subCommands = this.parent.subCommands;
        }
        if (args.length == 0 && !subCommands.isEmpty()) {
            helpText = new ArrayList<CallSite>();
            helpText.add((CallSite)((Object)(CyvClientColorHelper.color1.chatColor + commandName + " help menu:\u00a7r")));
            String chatColor2 = CyvClientConfig.getBoolean("whiteChat", false) ? CyvClientColorHelper.colors.get((int)12).chatColor : CyvClientColorHelper.color2.chatColor;
            for (CyvCommand c : subCommands) {
                helpText.add((CallSite)((Object)(CyvClientColorHelper.color1.chatColor + c.name + ": " + chatColor2 + c.helpString)));
            }
        } else {
            CyvCommand targetCommand;
            block12: {
                targetCommand = null;
                if (args.length > 0) {
                    for (CyvCommand cmd : subCommands) {
                        if (!cmd.name.toLowerCase().equals(args[0])) {
                            for (String s : cmd.aliases) {
                                if (!s.toLowerCase().equals(args[0])) continue;
                                targetCommand = cmd;
                                break block12;
                            }
                            continue;
                        }
                        targetCommand = cmd;
                        break;
                    }
                } else {
                    targetCommand = this.parent;
                }
            }
            if (targetCommand == null) {
                CyvFabric.sendChatMessage("Command not found. Use " + (String)commandPath + " for a list of commands.");
                return;
            }
            ArrayList<String> commandNames = new ArrayList<String>();
            commandNames.add(targetCommand.name);
            if (targetCommand.aliases != null) {
                commandNames.addAll(targetCommand.aliases);
            }
            CyvFabric.sendChatMessage("Command: /" + args[0] + "\nAliases: " + String.join((CharSequence)", ", commandNames) + "\nUsage: " + targetCommand.usage + "\n" + targetCommand.getDetailedHelp() + "\n" + CyvClientColorHelper.color1.chatColor + "\u00a7oNote: Use " + (String)commandPath + " to list subcommands.");
            return;
        }
        helpText.add((CallSite)((Object)(CyvClientColorHelper.color1.chatColor + "\u00a7oNote: Use " + (String)commandPath + " [command] for details")));
        CyvFabric.sendChatMessage(String.join((CharSequence)"\n", helpText));
    }
}

