/*
 * Decompiled with CFR 0.152.
 */
package net.cyvfabric.hud.structure;

import java.util.LinkedHashMap;
import java.util.Objects;
import net.cyvfabric.CyvFabric;
import net.cyvfabric.config.CyvClientConfig;
import net.cyvfabric.hud.structure.IRenderer;
import net.cyvfabric.hud.structure.ScreenPosition;
import net.minecraft.class_310;
import net.minecraft.class_332;

public abstract class DraggableHUDElement
implements IRenderer {
    protected final class_310 mc = class_310.method_1551();
    public ScreenPosition position;
    public boolean isVisible = true;
    public boolean isDraggable = true;
    public boolean isEnabled = true;

    public DraggableHUDElement() {
        this.setEnabled(this.isEnabled);
        this.position = this.getDefaultPosition();
    }

    public final int getLineOffset(ScreenPosition pos, int lineNum) {
        return pos.getAbsoluteY() + this.getLineOffset(lineNum);
    }

    private int getLineOffset(int lineNum) {
        Objects.requireNonNull(class_310.method_1551().field_1772);
        return (9 + 3) * lineNum;
    }

    public abstract ScreenPosition getDefaultPosition();

    public LinkedHashMap<String, CyvClientConfig.ConfigValue<?>> getConfigFields() {
        LinkedHashMap fields = new LinkedHashMap();
        fields.put("enabled", new CyvClientConfig.ConfigValue<Boolean>(this.enabledByDefault()));
        fields.put("posx", new CyvClientConfig.ConfigValue<Integer>(this.getDefaultPosition().getAbsoluteX()));
        fields.put("posy", new CyvClientConfig.ConfigValue<Integer>(this.getDefaultPosition().getAbsoluteY()));
        fields.put("visible", new CyvClientConfig.ConfigValue<Boolean>(true));
        return fields;
    }

    public void readConfigFields() {
        try {
            this.isEnabled = CyvClientConfig.getBoolean(this.getName() + "_enabled", this.isEnabled);
            int x = CyvClientConfig.getInt(this.getName() + "_posx", this.getDefaultPosition().getAbsoluteX());
            int y = CyvClientConfig.getInt(this.getName() + "_posy", this.getDefaultPosition().getAbsoluteY());
            this.isVisible = CyvClientConfig.getBoolean(this.getName() + "_visible", this.isVisible);
            this.position = new ScreenPosition(x, y);
        }
        catch (Exception e) {
            CyvFabric.LOGGER.error(String.valueOf(e));
            this.position = this.getDefaultPosition();
        }
    }

    public void saveConfigFields() {
        CyvClientConfig.set(this.getName() + "_enabled", this.isEnabled);
        CyvClientConfig.set(this.getName() + "_visible", this.isVisible);
        CyvClientConfig.set(this.getName() + "_posx", this.position.getAbsoluteX());
        CyvClientConfig.set(this.getName() + "_posy", this.position.getAbsoluteY());
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Override
    public void save(ScreenPosition pos) {
        this.position = pos;
    }

    @Override
    public ScreenPosition load() {
        return this.position;
    }

    public abstract String getName();

    public abstract String getDisplayName();

    public boolean enabledByDefault() {
        return true;
    }

    protected void drawString(class_332 context, Object string, int x, int y, long color) {
        this.drawString(context, string, x, y, color, true);
    }

    protected void drawString(class_332 context, Object string, int x, int y, long color, boolean shadow) {
        long drawColor = this.isVisible ? color : -5592406L;
        context.method_51433(this.mc.field_1772, string.toString(), x, y, Long.valueOf(drawColor).intValue(), shadow);
    }
}

