# Farmer's Delight Paperized

> **⚠️ EXPERIMENTAL / PROOF OF CONCEPT**
> This pack is currently in early development and is **not suitable for survival gameplay**. Many features are incomplete or missing. Use at your own risk!

A Paper/Spigot server implementation of the popular [Farmer's Delight](https://modrinth.com/mod/farmers-delight) mod, built using [CraftEngine](https://modrinth.com/plugin/craftengine).

## About

Farmer's Delight Paperized brings the farming and cooking experience of the original Farmer's Delight mod to Paper/Spigot servers without requiring any client-side mods. This pack adds new crops, foods, recipes, and tools to enhance your vanilla Minecraft survival experience.

## Screenshots

### Knives
![Knives](https://raw.githubusercontent.com/PalmarHealer/Farmers-Delight-Paperized-unofficial/master/img/knifes.png)

### Crops
![Crops](https://raw.githubusercontent.com/PalmarHealer/Farmers-Delight-Paperized-unofficial/master/img/crops.png)

### Blocks & Storage
![Blocks](https://raw.githubusercontent.com/PalmarHealer/Farmers-Delight-Paperized-unofficial/master/img/blocks.png)
![Cabinets](https://raw.githubusercontent.com/PalmarHealer/Farmers-Delight-Paperized-unofficial/master/img/cabinets.png)

### In-Game
![Crop Field](https://raw.githubusercontent.com/PalmarHealer/Farmers-Delight-Paperized-unofficial/master/img/in_game_crop_field.png)
![Cabinets In-Game](https://raw.githubusercontent.com/PalmarHealer/Farmers-Delight-Paperized-unofficial/master/img/in_game_cabinets.png)

### Categories
![Categories](https://raw.githubusercontent.com/PalmarHealer/Farmers-Delight-Paperized-unofficial/master/img/categories.png)

## Features

### Crops & Farming
- **Tomatoes** - Multi-stage growth crop with harvesting mechanics
- **Cabbage** - Coming soon
- **Onions** - Coming soon
- Custom crop growth and harvesting systems

### Tools
- **Knives** - Five tiers of knives (Flint, Iron, Gold, Diamond, Netherite)
  - Faster mining speed and higher damage than swords
  - Used for processing ingredients on the cutting board
  - Custom durability and attack speeds

### Blocks
- **Cutting Board** - Process ingredients with knives
  - Place items on the board and use a knife to cut them
  - Visual item display on the cutting board
  - Can be placed on any solid block
  - Breaks automatically if the block below is removed

### Items
- **Tomato** - Fresh harvested tomato
- **Rotten Tomato** - Rare drop from tomato harvesting (7.5% chance)
- More items coming soon!

## Requirements

- **Server**: Paper, Spigot, or compatible fork (1.21.4+) (tested on Paper 1.21.8)
- **Plugin**: [CraftEngine](https://modrinth.com/plugin/craftengine) v0.0.64 or higher
- **Client**: Vanilla Minecraft - no mods required!

## Installation

1. Download and install [CraftEngine](https://modrinth.com/plugin/craftengine) on your server
2. Download the latest release of Farmer's Delight Paperized
3. Extract the `farmers_delight_pack` folder to `plugins/CraftEngine/packs/`
4. Restart your server or run `/ce reload all`
5. Players will automatically receive the resource pack when joining

## Usage

### Growing Tomatoes
1. Craft or find tomato seeds
2. Plant seeds on farmland
3. Wait for the plant to grow through all stages (0-7)
4. Harvest when fully grown (stage 7) by right-clicking
5. The plant resets to stage 4 after harvesting

### Using the Cutting Board (currently not working)
1. Craft a cutting board (3 planks + 1 stick)
2. Place it on any solid block
3. Right-click with a food item (tomato, cabbage, onion) to place it
4. Right-click with any knife to process the item
5. Collect the processed items (typically 2x output)
6. Right-click with an empty hand to remove items without processing

### Crafting Knives
All knives follow the same pattern:
```
M
S
```
- M = Material (Flint, Iron Ingot, Gold Ingot, Diamond)
- S = Stick

Netherite Knife is crafted via smithing table with a Diamond Knife + Netherite Ingot

## Technical Details

- **Resource Pack**: Auto-generated and served by CraftEngine
- **No Client Mods**: Uses vanilla Minecraft's custom model data and item display entities
- **Performance**: Optimized for multiplayer servers
- **Compatibility**: Works alongside other CraftEngine packs

## Planned Features

- [ ] More crops (Cabbage, Onions, Rice, etc.)
- [ ] Cooking Pot - Multi-ingredient cooking system
- [ ] Stove - Cooking station
- [ ] More food items and recipes
- [ ] Crates for crop storage
- [ ] Additional farming tools

## Credits

- **Original Mod**: [Farmer's Delight](https://modrinth.com/mod/farmers-delight) by vectorwing
- **CraftEngine**: [Xiao-MoMi](https://modrinth.com/plugin/craftengine)
- **Textures & Models**: From the original Farmer's Delight mod

## License

This project is a server-side implementation of Farmer's Delight and uses assets from the original mod. Please respect the original mod's license.

## Support

- **Issues**: Report bugs on [GitHub Issues](https://github.com/PalmarHealer/Farmers-Delight-Paperized-unofficial/issues)
- **Wiki**: Check the [CraftEngine Wiki](https://xiao-momi.github.io/craft-engine-wiki/) for configuration help

## Contributing

Contributions are welcome! Feel free to:
- Report bugs and issues
- Submit pull requests
- Suggest new features
- Improve documentation

---

**Note**: This is an unofficial port and is not affiliated with the original Farmer's Delight mod.
