/*
 * Decompiled with CFR 0.152.
 */
package gvop.sarox;

import gvop.sarox.NetworkHandler;
import gvop.sarox.PlayerStatsProvider;
import gvop.sarox.SyncStatsPacket;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class PlayerStats {
    private int level = 1;
    private int points = 0;
    private int mobKills = 0;
    private int blocksBroken = 0;
    private int advancementCount = 0;
    private double strength = 0.0;
    private double maxHealth = 20.0;
    private double armor = 0.0;
    private Set<String> obtainedAdvancements = new HashSet<String>();

    public static PlayerStats getStats(Player player) {
        return (PlayerStats)player.getCapability(PlayerStatsProvider.PLAYER_STATS).orElse((Object)new PlayerStats());
    }

    public void addMobKill() {
        ++this.mobKills;
        if (this.mobKills >= 300) {
            this.mobKills = 0;
            ++this.points;
        }
    }

    public void addBlockBroken() {
        ++this.blocksBroken;
        if (this.blocksBroken >= 999) {
            this.blocksBroken = 0;
            ++this.points;
        }
    }

    public void addAdvancement(String advancementId) {
        if (!this.obtainedAdvancements.contains(advancementId)) {
            this.obtainedAdvancements.add(advancementId);
            ++this.advancementCount;
            if (this.advancementCount >= 7) {
                this.advancementCount = 0;
                ++this.points;
            }
        }
    }

    public boolean hasAdvancement(String advancementId) {
        return this.obtainedAdvancements.contains(advancementId);
    }

    public void levelUp() {
        if (this.points > 0) {
            ++this.level;
            --this.points;
            this.strength += 0.2;
            this.maxHealth += 1.5;
            this.armor += 0.5;
        }
    }

    public void applyLevelUpEffects(ServerPlayer player) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19618_, 20, 149, false, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19601_, 20, 149, false, false, false));
    }

    public void applyRespawnEffects(ServerPlayer player) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19601_, 20, 149, false, false, false));
    }

    public void addPoints(int amount) {
        this.points += amount;
    }

    public void addLevels(int amount) {
        this.level += amount;
        this.strength += (double)amount * 0.2;
        this.maxHealth += (double)amount * 1.5;
        this.armor += (double)amount * 0.5;
    }

    public void syncToClient(ServerPlayer player) {
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncStatsPacket(this.level, this.points, this.mobKills, this.blocksBroken, this.advancementCount, this.strength, this.maxHealth, this.armor));
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("level", this.level);
        tag.m_128405_("points", this.points);
        tag.m_128405_("mobKills", this.mobKills);
        tag.m_128405_("blocksBroken", this.blocksBroken);
        tag.m_128405_("advancementCount", this.advancementCount);
        tag.m_128347_("strength", this.strength);
        tag.m_128347_("maxHealth", this.maxHealth);
        tag.m_128347_("armor", this.armor);
        ListTag advancementsList = new ListTag();
        for (String adv : this.obtainedAdvancements) {
            advancementsList.add((Object)StringTag.m_129297_((String)adv));
        }
        tag.m_128365_("obtainedAdvancements", (Tag)advancementsList);
        return tag;
    }

    public void load(CompoundTag tag) {
        this.level = tag.m_128451_("level");
        this.points = tag.m_128451_("points");
        this.mobKills = tag.m_128451_("mobKills");
        this.blocksBroken = tag.m_128451_("blocksBroken");
        this.advancementCount = tag.m_128451_("advancementCount");
        this.strength = tag.m_128459_("strength");
        this.maxHealth = tag.m_128459_("maxHealth");
        this.armor = tag.m_128459_("armor");
        this.obtainedAdvancements.clear();
        if (tag.m_128425_("obtainedAdvancements", 9)) {
            ListTag advancementsList = tag.m_128437_("obtainedAdvancements", 8);
            for (int i = 0; i < advancementsList.size(); ++i) {
                this.obtainedAdvancements.add(advancementsList.m_128778_(i));
            }
        }
    }

    public void copyFrom(PlayerStats other) {
        this.level = other.level;
        this.points = other.points;
        this.mobKills = other.mobKills;
        this.blocksBroken = other.blocksBroken;
        this.advancementCount = other.advancementCount;
        this.strength = other.strength;
        this.maxHealth = other.maxHealth;
        this.armor = other.armor;
        this.obtainedAdvancements = new HashSet<String>(other.obtainedAdvancements);
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setPoints(int points) {
        this.points = points;
    }

    public void setMobKills(int mobKills) {
        this.mobKills = mobKills;
    }

    public void setBlocksBroken(int blocksBroken) {
        this.blocksBroken = blocksBroken;
    }

    public void setAdvancementCount(int advancementCount) {
        this.advancementCount = advancementCount;
    }

    public void setStrength(double strength) {
        this.strength = strength;
    }

    public void setMaxHealth(double maxHealth) {
        this.maxHealth = maxHealth;
    }

    public void setArmor(double armor) {
        this.armor = armor;
    }

    public int getLevel() {
        return this.level;
    }

    public int getPoints() {
        return this.points;
    }

    public int getMobKills() {
        return this.mobKills;
    }

    public int getBlocksBroken() {
        return this.blocksBroken;
    }

    public int getAdvancementCount() {
        return this.advancementCount;
    }

    public double getStrength() {
        return this.strength;
    }

    public double getMaxHealth() {
        return this.maxHealth;
    }

    public double getArmor() {
        return this.armor;
    }

    public Set<String> getObtainedAdvancements() {
        return new HashSet<String>(this.obtainedAdvancements);
    }
}

