/*
 * Decompiled with CFR 0.152.
 */
package gvop.sarox;

import gvop.sarox.PlayerStats;
import gvop.sarox.PlayerStatsProvider;
import gvop.sarox.PlayerStatsStorage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sarox")
public class PlayerStatsDataEvents {
    private static final Map<UUID, Integer> lastAdvancementTick = new HashMap<UUID, Integer>();
    private static final Set<UUID> gotAdvancementThisTick = new HashSet<UUID>();

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            String playerName = player2.m_7755_().getString();
            PlayerStats loadedStats = PlayerStatsStorage.loadPlayerStats(player2.m_20194_(), playerName);
            player2.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                stats.copyFrom(loadedStats);
                stats.syncToClient(player2);
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            String playerName = player2.m_7755_().getString();
            player2.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> PlayerStatsStorage.savePlayerStats(player2.m_20194_(), playerName, stats));
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            String playerName = player.m_7755_().getString();
            player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> PlayerStatsStorage.savePlayerStats(player.m_20194_(), playerName, stats));
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            String playerName = player2.m_7755_().getString();
            PlayerStats loadedStats = PlayerStatsStorage.loadPlayerStats(player2.m_20194_(), playerName);
            player2.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                stats.copyFrom(loadedStats);
                stats.applyRespawnEffects(player2);
                stats.syncToClient(player2);
            });
        }
    }

    @SubscribeEvent
    public static void onAdvancementEarned(AdvancementEvent.AdvancementEarnEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.f_19797_ < 40) {
            return;
        }
        int currentTick = player2.f_19797_;
        UUID id = player2.m_20148_();
        if (lastAdvancementTick.getOrDefault(id, -1) == currentTick && gotAdvancementThisTick.contains(id)) {
            player2.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                String advancementId = event.getAdvancement().m_138327_().toString();
                if (!stats.hasAdvancement(advancementId)) {
                    stats.getObtainedAdvancements().add(advancementId);
                    PlayerStatsStorage.savePlayerStats(player2.m_20194_(), player2.m_7755_().getString(), stats);
                }
            });
            return;
        }
        lastAdvancementTick.put(id, currentTick);
        gotAdvancementThisTick.add(id);
        player2.m_20194_().execute(() -> gotAdvancementThisTick.remove(id));
        String advancementId = event.getAdvancement().m_138327_().toString();
        player2.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
            if (!stats.hasAdvancement(advancementId)) {
                stats.addAdvancement(advancementId);
                stats.syncToClient(player2);
                PlayerStatsStorage.savePlayerStats(player2.m_20194_(), player2.m_7755_().getString(), stats);
            }
        });
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        event.getServer().m_6846_().m_11314_().forEach(player -> {
            String playerName = player.m_7755_().getString();
            player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> PlayerStatsStorage.savePlayerStats(player.m_20194_(), playerName, stats));
        });
        PlayerStatsStorage.clearCache();
    }
}

