/*
 * Decompiled with CFR 0.152.
 */
package gvop.sarox;

import gvop.sarox.PlayerStats;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;

public class PlayerStatsStorage {
    private static final String STATS_FILE = "sarox_stats.dat";
    private static final Map<String, PlayerStats> cachedStats = new HashMap<String, PlayerStats>();

    public static File getStatsFile(MinecraftServer server) {
        return server.m_129843_(LevelResource.f_78176_).resolve(STATS_FILE).toFile();
    }

    public static void savePlayerStats(MinecraftServer server, String playerName, PlayerStats stats) {
        try {
            File file = PlayerStatsStorage.getStatsFile(server);
            file.getParentFile().mkdirs();
            CompoundTag rootTag = file.exists() ? NbtIo.m_128937_((File)file) : new CompoundTag();
            CompoundTag playerTag = stats.save();
            rootTag.m_128365_(playerName, (Tag)playerTag);
            NbtIo.m_128944_((CompoundTag)rootTag, (File)file);
            cachedStats.put(playerName, stats);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static PlayerStats loadPlayerStats(MinecraftServer server, String playerName) {
        if (cachedStats.containsKey(playerName)) {
            return cachedStats.get(playerName);
        }
        try {
            File file = PlayerStatsStorage.getStatsFile(server);
            if (!file.exists()) {
                PlayerStats newStats = new PlayerStats();
                cachedStats.put(playerName, newStats);
                return newStats;
            }
            CompoundTag rootTag = NbtIo.m_128937_((File)file);
            if (rootTag.m_128441_(playerName)) {
                PlayerStats stats = new PlayerStats();
                stats.load(rootTag.m_128469_(playerName));
                cachedStats.put(playerName, stats);
                return stats;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        PlayerStats newStats = new PlayerStats();
        cachedStats.put(playerName, newStats);
        return newStats;
    }

    public static void clearCache() {
        cachedStats.clear();
    }
}

