/*
 * Decompiled with CFR 0.152.
 */
package gvop.sarox;

import com.mojang.blaze3d.systems.RenderSystem;
import gvop.sarox.CyberButton;
import gvop.sarox.LevelUpPacket;
import gvop.sarox.NetworkHandler;
import gvop.sarox.PlayerStats;
import gvop.sarox.SupportButton;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class RpgMenuScreen
extends Screen {
    private static final int MAIN_WIDTH = 210;
    private static final int MAIN_HEIGHT = 105;
    private static final int HEADER_WIDTH = 180;
    private static final int HEADER_HEIGHT = 22;
    private static final int PLAYER_HEAD_SIZE = 50;
    private static final int BUTTON_WIDTH = 105;
    private static final int BUTTON_HEIGHT = 20;
    private PlayerStats stats;
    private CyberButton levelUpButton;
    private int mainX;
    private int mainY;
    private int headerX;
    private int headerY;
    private int headX;
    private int headY;
    private boolean showLevelTooltip = false;
    private boolean showPointsTooltip = false;
    private SupportButton supportButton;

    public RpgMenuScreen() {
        super((Component)Component.m_237115_((String)"sarox.menu.title"));
        this.stats = PlayerStats.getStats((Player)Minecraft.m_91087_().f_91074_);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.mainX = (this.f_96543_ - 210) / 2;
        this.mainY = (this.f_96544_ - 105) / 2;
        this.headerX = this.mainX + 10 + 20;
        this.headerY = this.mainY - 1;
        this.headX = this.mainX - 50 - 5 + 34;
        this.headY = this.mainY - 29;
        int buttonX = this.mainX + 52;
        int buttonY = this.mainY + 105 - 20 - 15;
        this.levelUpButton = new CyberButton(buttonX, buttonY, 105, 20, (Component)Component.m_237115_((String)"sarox.button.levelup"), button -> {
            if (this.stats.getPoints() > 0) {
                NetworkHandler.CHANNEL.sendToServer((Object)new LevelUpPacket());
            }
        });
        int supportButtonX = this.mainX + 210;
        int supportButtonY = this.mainY + 22 + 53;
        this.supportButton = new SupportButton(supportButtonX, supportButtonY, 20, (Component)Component.m_237115_((String)"sarox.button.support"), button -> Util.m_137581_().m_137646_("https://boosty.to/gvoper"));
        this.m_142416_((GuiEventListener)this.supportButton);
        this.m_142416_((GuiEventListener)this.levelUpButton);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        this.renderPlayerHeadBox(graphics, this.headX, this.headY, 50, mouseX, mouseY);
        this.renderCyberHeader(graphics, this.headerX, this.headerY, 180, 22);
        this.renderCyberPanel(graphics, this.mainX, this.mainY + 22, 210, 83);
        this.renderStats(graphics, mouseX, mouseY);
        this.renderTooltips(graphics, mouseX, mouseY);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private void renderCyberPanel(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.m_280024_(x + 1, y + 1, x + width - 1, y + height - 1, -536146672, -536278258);
        int cornerColor = -14816791;
        int cornerLen = 7;
        int t = 1;
        graphics.m_280509_(x, y, x + cornerLen, y + t, cornerColor);
        graphics.m_280509_(x, y, x + t, y + cornerLen, cornerColor);
        graphics.m_280509_(x + width - cornerLen, y, x + width, y + t, cornerColor);
        graphics.m_280509_(x + width - t, y, x + width, y + cornerLen, cornerColor);
        graphics.m_280509_(x, y + height - t, x + cornerLen, y + height, cornerColor);
        graphics.m_280509_(x, y + height - cornerLen, x + t, y + height, cornerColor);
        graphics.m_280509_(x + width - cornerLen, y + height - t, x + width, y + height, cornerColor);
        graphics.m_280509_(x + width - t, y + height - cornerLen, x + width, y + height, cornerColor);
    }

    private void renderCyberHeader(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.m_280024_(x + 1, y + 1, x + width - 1, y + height - 1, -267382508, -267908339);
        int cornerColor = -13984298;
        int cornerLen = 7;
        int t = 1;
        graphics.m_280509_(x, y, x + cornerLen, y + t, cornerColor);
        graphics.m_280509_(x, y, x + t, y + cornerLen, cornerColor);
        graphics.m_280509_(x + width - cornerLen, y, x + width, y + t, cornerColor);
        graphics.m_280509_(x + width - t, y, x + width, y + cornerLen, cornerColor);
        graphics.m_280509_(x, y + height - t, x + cornerLen, y + height, cornerColor);
        graphics.m_280509_(x, y + height - cornerLen, x + t, y + height, cornerColor);
        graphics.m_280509_(x + width - cornerLen, y + height - t, x + width, y + height, cornerColor);
        graphics.m_280509_(x + width - t, y + height - cornerLen, x + width, y + height, cornerColor);
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            String playerName = this.f_96541_.f_91074_.m_7755_().getString();
            int nameWidth = this.f_96547_.m_92895_(playerName);
            int nameX = x + (width - nameWidth) / 2;
            int nameY = y + (height - 8) / 2;
            graphics.m_280056_(this.f_96547_, playerName, nameX, nameY, -1, false);
        }
    }

    private void renderPlayerHeadBox(GuiGraphics graphics, int x, int y, int size, int mouseX, int mouseY) {
        graphics.m_280024_(x + 1, y + 1, x + size - 1, y + size - 1, -804254192, -1073215992);
        int cornerColor = -60269;
        int cornerLen = 7;
        int t = 1;
        graphics.m_280509_(x, y, x + cornerLen, y + t, cornerColor);
        graphics.m_280509_(x, y, x + t, y + cornerLen, cornerColor);
        graphics.m_280509_(x + size - cornerLen, y, x + size, y + t, cornerColor);
        graphics.m_280509_(x + size - t, y, x + size, y + cornerLen, cornerColor);
        graphics.m_280509_(x, y + size - t, x + cornerLen, y + size, cornerColor);
        graphics.m_280509_(x, y + size - cornerLen, x + t, y + size, cornerColor);
        graphics.m_280509_(x + size - cornerLen, y + size - t, x + size, y + size, cornerColor);
        graphics.m_280509_(x + size - t, y + size - cornerLen, x + size, y + size, cornerColor);
        int neon = -39169;
        int baseAlpha = 20;
        for (int i = 0; i < 8; ++i) {
            int alpha = Math.max(0, baseAlpha - i * 3);
            if (alpha <= 0) continue;
            int col = alpha << 24 | neon & 0xFFFFFF;
            graphics.m_280509_(x + 2, y + 2 + i * 2, x + size - 2, y + 2 + i * 2 + 2, col);
        }
        this.enableScissor(x + 2, y + 2, size - 4, size - 4);
        this.renderPlayerModel(graphics, x + size / 2, y + size + 49, 50, mouseX, mouseY);
        this.disableScissor();
    }

    private void renderPlayerModel(GuiGraphics graphics, int centerX, int centerY, int size, int mouseX, int mouseY) {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            float xRot = (float)Math.atan((float)(centerY - 50 - mouseY) / 40.0f);
            float yRot = (float)Math.atan((float)(centerX - mouseX) / 40.0f);
            Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
            Quaternionf quaternionf1 = new Quaternionf().rotateX(xRot * 20.0f * ((float)Math.PI / 180));
            quaternionf.mul((Quaternionfc)quaternionf1);
            float bodyYRot = this.f_96541_.f_91074_.f_20883_;
            float yRot2 = this.f_96541_.f_91074_.m_146908_();
            float xRot2 = this.f_96541_.f_91074_.m_146909_();
            float yHeadRotO = this.f_96541_.f_91074_.f_20886_;
            float yHeadRot = this.f_96541_.f_91074_.f_20885_;
            this.f_96541_.f_91074_.f_20883_ = 180.0f + yRot * 20.0f;
            this.f_96541_.f_91074_.m_146922_(180.0f + yRot * 40.0f);
            this.f_96541_.f_91074_.m_146926_(-xRot * 20.0f);
            this.f_96541_.f_91074_.f_20885_ = this.f_96541_.f_91074_.m_146908_();
            this.f_96541_.f_91074_.f_20886_ = this.f_96541_.f_91074_.m_146908_();
            InventoryScreen.m_280432_((GuiGraphics)graphics, (int)centerX, (int)centerY, (int)size, (Quaternionf)quaternionf, (Quaternionf)quaternionf1, (LivingEntity)this.f_96541_.f_91074_);
            this.f_96541_.f_91074_.f_20883_ = bodyYRot;
            this.f_96541_.f_91074_.m_146922_(yRot2);
            this.f_96541_.f_91074_.m_146926_(xRot2);
            this.f_96541_.f_91074_.f_20886_ = yHeadRotO;
            this.f_96541_.f_91074_.f_20885_ = yHeadRot;
        }
    }

    private void renderStats(GuiGraphics graphics, int mouseX, int mouseY) {
        int textY = this.mainY + 22 + 15;
        String levelText = Component.m_237110_((String)"sarox.stats.level", (Object[])new Object[]{this.stats.getLevel()}).getString();
        String pointsText = Component.m_237110_((String)"sarox.stats.points", (Object[])new Object[]{this.stats.getPoints()}).getString();
        int levelWidth = this.f_96547_.m_92895_(levelText);
        int pointsWidth = this.f_96547_.m_92895_(pointsText);
        int levelX = this.mainX + (210 - levelWidth) / 2;
        int pointsX = this.mainX + (210 - pointsWidth) / 2;
        graphics.m_280056_(this.f_96547_, levelText, levelX, textY, -7344144, false);
        graphics.m_280056_(this.f_96547_, pointsText, pointsX, textY + 16, -60269, false);
        this.showLevelTooltip = mouseX >= levelX && mouseX <= levelX + levelWidth && mouseY >= textY && mouseY <= textY + 10;
        this.showPointsTooltip = mouseX >= pointsX && mouseX <= pointsX + pointsWidth && mouseY >= textY + 16 && mouseY <= textY + 26;
    }

    private void renderTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.supportButton.m_198029_()) {
            graphics.m_280677_(this.f_96547_, List.of(Component.m_237115_((String)"sarox.tooltip.support_description")), Optional.empty(), mouseX, mouseY);
            return;
        }
        if (this.levelUpButton.m_198029_() && !this.levelUpButton.isPressed()) {
            graphics.m_280677_(this.f_96547_, List.of(Component.m_237115_((String)"sarox.tooltip.on_levelup"), Component.m_237115_((String)"sarox.tooltip.strength_gain"), Component.m_237115_((String)"sarox.tooltip.hp_gain"), Component.m_237115_((String)"sarox.tooltip.armor_gain")), Optional.empty(), mouseX, mouseY);
            return;
        }
        if (this.showLevelTooltip) {
            graphics.m_280677_(this.f_96547_, List.of(Component.m_237115_((String)"sarox.tooltip.current_stats"), Component.m_237110_((String)"sarox.tooltip.strength", (Object[])new Object[]{String.format("%.1f", this.stats.getStrength())}), Component.m_237110_((String)"sarox.tooltip.hp", (Object[])new Object[]{String.format("%.1f", this.stats.getMaxHealth())}), Component.m_237110_((String)"sarox.tooltip.armor", (Object[])new Object[]{String.format("%.1f", this.stats.getArmor())})), Optional.empty(), mouseX, mouseY);
            return;
        }
        if (this.showPointsTooltip) {
            graphics.m_280677_(this.f_96547_, List.of(Component.m_237115_((String)"sarox.tooltip.point_gain"), Component.m_237110_((String)"sarox.tooltip.mobs_killed", (Object[])new Object[]{this.stats.getMobKills(), 300}), Component.m_237110_((String)"sarox.tooltip.blocks_broken", (Object[])new Object[]{this.stats.getBlocksBroken(), 999}), Component.m_237110_((String)"sarox.tooltip.advancements_earned", (Object[])new Object[]{this.stats.getAdvancementCount(), 7})), Optional.empty(), mouseX, mouseY);
        }
    }

    private void enableScissor(int x, int y, int width, int height) {
        double scale = this.f_96541_.m_91268_().m_85449_();
        int screenHeight = this.f_96541_.m_91268_().m_85442_();
        RenderSystem.enableScissor((int)((int)((double)x * scale)), (int)((int)((double)screenHeight - (double)(y + height) * scale)), (int)((int)((double)width * scale)), (int)((int)((double)height * scale)));
    }

    private void disableScissor() {
        RenderSystem.disableScissor();
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.levelUpButton != null) {
            this.levelUpButton.m_7691_(mouseX, mouseY);
            this.levelUpButton.m_93692_(false);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }
}

