/*
 * Decompiled with CFR 0.152.
 */
package gvop.sarox;

import gvop.sarox.PlayerStatsProvider;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SyncStatsPacket {
    private final int level;
    private final int points;
    private final int mobKills;
    private final int blocksBroken;
    private final int advancementCount;
    private final double strength;
    private final double maxHealth;
    private final double armor;

    public SyncStatsPacket(int level, int points, int mobKills, int blocksBroken, int advancementCount, double strength, double maxHealth, double armor) {
        this.level = level;
        this.points = points;
        this.mobKills = mobKills;
        this.blocksBroken = blocksBroken;
        this.advancementCount = advancementCount;
        this.strength = strength;
        this.maxHealth = maxHealth;
        this.armor = armor;
    }

    public SyncStatsPacket(FriendlyByteBuf buf) {
        this.level = buf.readInt();
        this.points = buf.readInt();
        this.mobKills = buf.readInt();
        this.blocksBroken = buf.readInt();
        this.advancementCount = buf.readInt();
        this.strength = buf.readDouble();
        this.maxHealth = buf.readDouble();
        this.armor = buf.readDouble();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.level);
        buf.writeInt(this.points);
        buf.writeInt(this.mobKills);
        buf.writeInt(this.blocksBroken);
        buf.writeInt(this.advancementCount);
        buf.writeDouble(this.strength);
        buf.writeDouble(this.maxHealth);
        buf.writeDouble(this.armor);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                mc.f_91074_.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                    stats.setLevel(this.level);
                    stats.setPoints(this.points);
                    stats.setMobKills(this.mobKills);
                    stats.setBlocksBroken(this.blocksBroken);
                    stats.setAdvancementCount(this.advancementCount);
                    stats.setStrength(this.strength);
                    stats.setMaxHealth(this.maxHealth);
                    stats.setArmor(this.armor);
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

