/*
 * Decompiled with CFR 0.152.
 */
package gvop.sarox.mixin;

import com.google.common.collect.Multimap;
import gvop.sarox.PlayerStatsProvider;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public class ItemTooltipMixin {
    @Inject(method={"getTooltipLines"}, at={@At(value="RETURN")})
    private void modifyDamageTooltip(Player player, TooltipFlag flag, CallbackInfoReturnable<List<Component>> cir) {
        if (player == null) {
            return;
        }
        ItemStack stack = (ItemStack)this;
        player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
            double strengthBonus = stats.getStrength();
            if (strengthBonus <= 0.0) {
                return;
            }
            List tooltip = (List)cir.getReturnValue();
            Multimap attributes = stack.m_41638_(EquipmentSlot.MAINHAND);
            if (attributes.containsKey((Object)Attributes.f_22281_)) {
                double weaponDamage = attributes.get((Object)Attributes.f_22281_).stream().mapToDouble(AttributeModifier::m_22218_).sum();
                for (int i = 0; i < tooltip.size(); ++i) {
                    Component line = (Component)tooltip.get(i);
                    String text = line.getString();
                    if (!text.matches(".*\\d+.*") || !text.toLowerCase().contains("attack") && !text.toLowerCase().contains("damage") && !text.contains("\u0443\u0440\u043e\u043d") && !text.contains("\u0430\u0442\u0430\u043a")) continue;
                    double totalDamage = weaponDamage + 1.0 + strengthBonus;
                    MutableComponent newLine = Component.m_237113_((String)" ").m_7220_((Component)Component.m_237113_((String)ItemStack.f_41584_.format(totalDamage)).m_130940_(ChatFormatting.DARK_GREEN)).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237115_((String)"attribute.name.generic.attack_damage").m_130940_(ChatFormatting.DARK_GREEN));
                    tooltip.set(i, newLine);
                    return;
                }
            }
        });
    }
}

