/*
 * Decompiled with CFR 0.152.
 */
package gvop.sarox.mixin;

import gvop.sarox.PlayerStatsProvider;
import java.util.UUID;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public class PlayerAttributesMixin {
    @Unique
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("a1b2c3d4-e5f6-7890-abcd-ef1234567890");
    @Unique
    private double sarox$lastArmorValue = -1.0;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void updateAttributes(CallbackInfo ci) {
        Player player = (Player)this;
        player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
            double armorBonus;
            AttributeInstance armorAttr;
            AttributeInstance maxHealthAttr = player.m_21051_(Attributes.f_22276_);
            if (maxHealthAttr != null) {
                double targetHealth = stats.getMaxHealth();
                if (maxHealthAttr.m_22115_() != targetHealth) {
                    maxHealthAttr.m_22100_(targetHealth);
                    if ((double)player.m_21223_() > targetHealth) {
                        player.m_21153_((float)targetHealth);
                    }
                }
            }
            if ((armorAttr = player.m_21051_(Attributes.f_22284_)) != null && this.sarox$lastArmorValue != (armorBonus = stats.getArmor())) {
                AttributeModifier existingModifier = armorAttr.m_22111_(ARMOR_MODIFIER_UUID);
                if (existingModifier != null) {
                    armorAttr.m_22120_(ARMOR_MODIFIER_UUID);
                }
                if (armorBonus > 0.0) {
                    AttributeModifier modifier = new AttributeModifier(ARMOR_MODIFIER_UUID, "sarox_armor_bonus", armorBonus, AttributeModifier.Operation.ADDITION);
                    armorAttr.m_22125_(modifier);
                }
                this.sarox$lastArmorValue = armorBonus;
            }
        });
    }
}

