/*
 * Decompiled with CFR 0.152.
 */
package gvop.sarox;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class PlacedBlocksTracker
extends SavedData {
    private static final String DATA_NAME = "sarox_placed_blocks";
    private final Set<BlockPos> placedBlocks = new HashSet<BlockPos>();

    public static PlacedBlocksTracker get(ServerLevel level) {
        return (PlacedBlocksTracker)level.m_8895_().m_164861_(PlacedBlocksTracker::load, PlacedBlocksTracker::new, DATA_NAME);
    }

    public static PlacedBlocksTracker load(CompoundTag tag) {
        PlacedBlocksTracker tracker = new PlacedBlocksTracker();
        ListTag list = tag.m_128437_("PlacedBlocks", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag posTag = list.m_128728_(i);
            int x = posTag.m_128451_("x");
            int y = posTag.m_128451_("y");
            int z = posTag.m_128451_("z");
            tracker.placedBlocks.add(new BlockPos(x, y, z));
        }
        return tracker;
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag tag) {
        ListTag list = new ListTag();
        for (BlockPos pos : this.placedBlocks) {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128405_("x", pos.m_123341_());
            posTag.m_128405_("y", pos.m_123342_());
            posTag.m_128405_("z", pos.m_123343_());
            list.add((Object)posTag);
        }
        tag.m_128365_("PlacedBlocks", (Tag)list);
        return tag;
    }

    public void addPlacedBlock(BlockPos pos) {
        this.placedBlocks.add(pos.m_7949_());
        this.m_77762_();
    }

    public boolean isPlayerPlaced(BlockPos pos) {
        return this.placedBlocks.contains(pos);
    }

    public void removeBlock(BlockPos pos) {
        this.placedBlocks.remove(pos);
        this.m_77762_();
    }
}

