/*
 * Decompiled with CFR 0.152.
 */
package gvop.sarox;

import gvop.sarox.NetworkHandler;
import gvop.sarox.PlayerStatsProvider;
import gvop.sarox.SyncStatsPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class PlayerStats {
    private int level = 1;
    private int points = 0;
    private int mobKills = 0;
    private int blocksBroken = 0;
    private double strength = 0.0;

    public static PlayerStats getStats(Player player) {
        return (PlayerStats)player.getCapability(PlayerStatsProvider.PLAYER_STATS).orElse((Object)new PlayerStats());
    }

    public void addMobKill() {
        ++this.mobKills;
        if (this.mobKills >= 300) {
            this.mobKills = 0;
            ++this.points;
        }
    }

    public void addBlockBroken() {
        ++this.blocksBroken;
        if (this.blocksBroken >= 999) {
            this.blocksBroken = 0;
            ++this.points;
        }
    }

    public void levelUp() {
        if (this.points > 0) {
            ++this.level;
            --this.points;
            this.strength += 0.2;
        }
    }

    public void addPoints(int amount) {
        this.points += amount;
    }

    public void addLevels(int amount) {
        this.level += amount;
        this.strength += (double)amount * 0.2;
    }

    public void syncToClient(ServerPlayer player) {
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncStatsPacket(this.level, this.points, this.mobKills, this.blocksBroken, this.strength));
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("level", this.level);
        tag.m_128405_("points", this.points);
        tag.m_128405_("mobKills", this.mobKills);
        tag.m_128405_("blocksBroken", this.blocksBroken);
        tag.m_128347_("strength", this.strength);
        return tag;
    }

    public void load(CompoundTag tag) {
        this.level = tag.m_128451_("level");
        this.points = tag.m_128451_("points");
        this.mobKills = tag.m_128451_("mobKills");
        this.blocksBroken = tag.m_128451_("blocksBroken");
        this.strength = tag.m_128459_("strength");
    }

    public void copyFrom(PlayerStats other) {
        this.level = other.level;
        this.points = other.points;
        this.mobKills = other.mobKills;
        this.blocksBroken = other.blocksBroken;
        this.strength = other.strength;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setPoints(int points) {
        this.points = points;
    }

    public void setMobKills(int mobKills) {
        this.mobKills = mobKills;
    }

    public void setBlocksBroken(int blocksBroken) {
        this.blocksBroken = blocksBroken;
    }

    public void setStrength(double strength) {
        this.strength = strength;
    }

    public int getLevel() {
        return this.level;
    }

    public int getPoints() {
        return this.points;
    }

    public int getMobKills() {
        return this.mobKills;
    }

    public int getBlocksBroken() {
        return this.blocksBroken;
    }

    public double getStrength() {
        return this.strength;
    }
}

