/*
 * Decompiled with CFR 0.152.
 */
package gvop.sarox;

import gvop.sarox.PlacedBlocksTracker;
import gvop.sarox.PlayerStatsProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ServerEventHandler {
    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            LivingEntity killed = event.getEntity();
            if (killed.getPersistentData().m_128471_("FromSpawner")) {
                return;
            }
            player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                stats.addMobKill();
                stats.syncToClient(player);
            });
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        if (state.m_60713_(Blocks.f_50652_)) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        PlacedBlocksTracker tracker = PlacedBlocksTracker.get(level);
        if (tracker.isPlayerPlaced(pos)) {
            return;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                stats.addBlockBroken();
                stats.syncToClient(serverPlayer);
            });
        }
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor levelAccessor;
        if (event.getEntity() instanceof Player && (levelAccessor = event.getLevel()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            BlockPos pos = event.getPos();
            PlacedBlocksTracker tracker = PlacedBlocksTracker.get(level);
            tracker.addPlacedBlock(pos);
        }
    }
}

