/*
 * Decompiled with CFR 0.152.
 */
package gvop.sarox;

import gvop.sarox.PlayerStatsProvider;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SyncStatsPacket {
    private final int level;
    private final int points;
    private final int mobKills;
    private final int blocksBroken;
    private final double strength;

    public SyncStatsPacket(int level, int points, int mobKills, int blocksBroken, double strength) {
        this.level = level;
        this.points = points;
        this.mobKills = mobKills;
        this.blocksBroken = blocksBroken;
        this.strength = strength;
    }

    public SyncStatsPacket(FriendlyByteBuf buf) {
        this.level = buf.readInt();
        this.points = buf.readInt();
        this.mobKills = buf.readInt();
        this.blocksBroken = buf.readInt();
        this.strength = buf.readDouble();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.level);
        buf.writeInt(this.points);
        buf.writeInt(this.mobKills);
        buf.writeInt(this.blocksBroken);
        buf.writeDouble(this.strength);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                mc.f_91074_.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                    stats.setLevel(this.level);
                    stats.setPoints(this.points);
                    stats.setMobKills(this.mobKills);
                    stats.setBlocksBroken(this.blocksBroken);
                    stats.setStrength(this.strength);
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

