/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.annuus.chunk.data;

import com.github.cao.awa.annuus.util.io.IOUtil;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class AnnuusChunkData {
    private static final Logger LOGGER = LogManager.getLogger((String)"AnnuusChunkData");
    private static final StreamCodec<ByteBuf, Map<Heightmap.Types, long[]>> HEIGHTMAPS_PACKET_CODEC = ByteBufCodecs.map(size -> new EnumMap(Heightmap.Types.class), (StreamCodec)Heightmap.Types.STREAM_CODEC, (StreamCodec)ByteBufCodecs.LONG_ARRAY);
    private static final int MAX_SECTIONS_DATA_SIZE = 0x200000;
    private final Map<Heightmap.Types, long[]> heightmap;
    private final byte[] sectionsData;
    private final List<BlockEntityData> blockEntities;

    public AnnuusChunkData(LevelChunk chunk) {
        this.heightmap = chunk.getHeightmaps().stream().filter(entryx -> ((Heightmap.Types)entryx.getKey()).sendToClient()).collect(Collectors.toMap(Map.Entry::getKey, entryx -> (long[])((Heightmap)entryx.getValue()).getRawData().clone()));
        this.sectionsData = new byte[AnnuusChunkData.getSectionsPacketSize(chunk)];
        AnnuusChunkData.writeSections(new FriendlyByteBuf(this.getWritableSectionsDataBuf()), chunk);
        this.blockEntities = Lists.newArrayList();
        for (Map.Entry entry : chunk.getBlockEntities().entrySet()) {
            this.blockEntities.add(BlockEntityData.of((BlockEntity)entry.getValue()));
        }
    }

    public AnnuusChunkData(RegistryFriendlyByteBuf buf, int x, int z) {
        this.heightmap = (Map)HEIGHTMAPS_PACKET_CODEC.decode((Object)buf);
        int i = buf.readVarInt();
        if (i > 0x200000) {
            throw new RuntimeException("Chunk Packet trying to allocate too much memory on read.");
        }
        this.sectionsData = new byte[i];
        buf.readBytes(this.sectionsData);
        this.blockEntities = (List)BlockEntityData.LIST_PACKET_CODEC.decode((Object)buf);
    }

    public void write(RegistryFriendlyByteBuf buf) {
        StringBuilder builder = new StringBuilder();
        try {
            Random random = new Random();
            File file = new File("test-data/" + random.nextInt() + ".dat");
            file.getParentFile().mkdirs();
            file.createNewFile();
            IOUtil.write((OutputStream)new FileOutputStream(file), this.sectionsData);
        }
        catch (Exception e) {
            LOGGER.info("wtf?");
            e.printStackTrace();
        }
        LOGGER.info("awa");
        HEIGHTMAPS_PACKET_CODEC.encode((Object)buf, this.heightmap);
        buf.writeVarInt(this.sectionsData.length);
        buf.writeBytes(this.sectionsData);
        BlockEntityData.LIST_PACKET_CODEC.encode((Object)buf, this.blockEntities);
    }

    private static int getSectionsPacketSize(LevelChunk chunk) {
        int i = 0;
        for (LevelChunkSection chunkSection : chunk.getSections()) {
            i += chunkSection.getSerializedSize();
        }
        return i;
    }

    private ByteBuf getWritableSectionsDataBuf() {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.sectionsData);
        byteBuf.writerIndex(0);
        return byteBuf;
    }

    public static void writeSections(FriendlyByteBuf buf, LevelChunk chunk) {
        for (LevelChunkSection chunkSection : chunk.getSections()) {
            chunkSection.write(buf);
        }
        if (buf.writerIndex() != buf.capacity()) {
            int var10002 = buf.capacity();
            throw new IllegalStateException("Didn't fill chunk buffer: expected " + var10002 + " bytes, got " + buf.writerIndex());
        }
    }

    public Consumer<BlockEntityVisitor> getBlockEntities(int x, int z) {
        return visitor -> this.iterateBlockEntities((BlockEntityVisitor)visitor, x, z);
    }

    private void iterateBlockEntities(BlockEntityVisitor consumer, int x, int z) {
        int i = 16 * x;
        int j = 16 * z;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (BlockEntityData blockEntityData : this.blockEntities) {
            int k = i + SectionPos.sectionRelative((int)(blockEntityData.localXz >> 4));
            int l = j + SectionPos.sectionRelative((int)blockEntityData.localXz);
            mutable.set(k, blockEntityData.y, l);
            consumer.accept((BlockPos)mutable, blockEntityData.type, blockEntityData.nbt);
        }
    }

    public FriendlyByteBuf getSectionsDataBuf() {
        return new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])this.sectionsData));
    }

    public Map<Heightmap.Types, long[]> getHeightmap() {
        return this.heightmap;
    }

    static class BlockEntityData {
        public static final StreamCodec<RegistryFriendlyByteBuf, BlockEntityData> PACKET_CODEC = StreamCodec.ofMember(BlockEntityData::write, BlockEntityData::new);
        public static final StreamCodec<RegistryFriendlyByteBuf, List<BlockEntityData>> LIST_PACKET_CODEC = PACKET_CODEC.apply(ByteBufCodecs.list());
        final int localXz;
        final int y;
        final BlockEntityType<?> type;
        @Nullable
        final CompoundTag nbt;

        private BlockEntityData(int localXz, int y, BlockEntityType<?> type, @Nullable CompoundTag nbt) {
            this.localXz = localXz;
            this.y = y;
            this.type = type;
            this.nbt = nbt;
        }

        private BlockEntityData(RegistryFriendlyByteBuf buf) {
            this.localXz = buf.readByte();
            this.y = buf.readShort();
            this.type = (BlockEntityType)ByteBufCodecs.registry((ResourceKey)Registries.BLOCK_ENTITY_TYPE).decode((Object)buf);
            this.nbt = buf.readNbt();
        }

        private void write(RegistryFriendlyByteBuf buf) {
            buf.writeByte(this.localXz);
            buf.writeShort(this.y);
            ByteBufCodecs.registry((ResourceKey)Registries.BLOCK_ENTITY_TYPE).encode((Object)buf, this.type);
            buf.writeNbt((Tag)this.nbt);
        }

        static BlockEntityData of(BlockEntity blockEntity) {
            CompoundTag nbtCompound = blockEntity.getUpdateTag((HolderLookup.Provider)blockEntity.getLevel().registryAccess());
            BlockPos blockPos = blockEntity.getBlockPos();
            int i = SectionPos.sectionRelative((int)blockPos.getX()) << 4 | SectionPos.sectionRelative((int)blockPos.getZ());
            return new BlockEntityData(i, blockPos.getY(), blockEntity.getType(), nbtCompound.isEmpty() ? null : nbtCompound);
        }
    }

    @FunctionalInterface
    public static interface BlockEntityVisitor {
        public void accept(BlockPos var1, BlockEntityType<?> var2, @Nullable CompoundTag var3);
    }
}

