/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.annuus.command;

import com.github.cao.awa.annuus.Annuus;
import com.github.cao.awa.annuus.config.AnnuusConfig;
import com.github.cao.awa.annuus.config.key.AnnuusConfigKey;
import com.github.cao.awa.annuus.server.AnnuusServer;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;

public class AnnuusConfigCommand {
    public static void register(MinecraftServer server) {
        AnnuusConfigCommand.register((CommandDispatcher<CommandSourceStack>)server.getCommands().getDispatcher());
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"annuus").executes(context -> {
            int enabledConfigs = Annuus.CONFIG.collectEnabled().size();
            if (((CommandSourceStack)context.getSource()).getPlayer() != null) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.nullToEmpty((String)("Annuus '1.0.15'(" + Annuus.loadingPlatform + ", protocol version " + AnnuusServer.getAnnuusVersion(((CommandSourceStack)context.getSource()).getPlayer()) + ") successfully loaded, has " + enabledConfigs + " configs enabled")), false);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.nullToEmpty((String)("Annuus '1.0.15'(" + Annuus.loadingPlatform + ") successfully loaded, has " + enabledConfigs + " configs enabled")), false);
            }
            return 0;
        })).requires(context -> context.hasPermission(4))).then(AnnuusConfigCommand.createStringConfigNode(AnnuusConfig.CHUNK_COMPRESS))).then(AnnuusConfigCommand.createStringConfigNode(AnnuusConfig.BLOCK_UPDATES_COMPRESS))).then(AnnuusConfigCommand.createBoolConfigNode(AnnuusConfig.SHORT_RECIPES))).then(AnnuusConfigCommand.createStringConfigNode(AnnuusConfig.SHORT_RECIPES_COMPRESS)));
    }

    private static <X> int changeConfigTemporary(CommandContext<CommandSourceStack> context, AnnuusConfigKey<X> key, BiFunction<CommandContext<CommandSourceStack>, String, X> argument) {
        return AnnuusConfigCommand.changeConfig(context, key, argument, true);
    }

    private static <X> int changeConfig(CommandContext<CommandSourceStack> context, AnnuusConfigKey<X> key, BiFunction<CommandContext<CommandSourceStack>, String, X> argument) {
        return AnnuusConfigCommand.changeConfig(context, key, argument, false);
    }

    private static <X> int changeConfig(CommandContext<CommandSourceStack> context, AnnuusConfigKey<X> key, BiFunction<CommandContext<CommandSourceStack>, String, X> argument, boolean temporary) {
        Object value = argument.apply(context, key.name());
        Annuus.CONFIG.setConfig(key, value);
        if (temporary) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.nullToEmpty((String)("Config '" + key.name() + "' is '" + String.valueOf(value) + "' temporarily")), true);
        } else {
            Annuus.PERSISTENT_CONFIG.setConfig(key, value);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.nullToEmpty((String)("Config '" + key.name() + "' is '" + String.valueOf(value) + "' now")), true);
            ((CommandSourceStack)context.getSource()).getServer().execute(Annuus::writeConfig);
        }
        return 0;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createBoolConfigNode(AnnuusConfigKey<Boolean> key) {
        return AnnuusConfigCommand.createConfigNode(key, BoolArgumentType::bool, BoolArgumentType::getBool);
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createIntConfigNode(AnnuusConfigKey<Integer> key) {
        return AnnuusConfigCommand.createConfigNode(key, IntegerArgumentType::integer, IntegerArgumentType::getInteger);
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createStringConfigNode(AnnuusConfigKey<String> key) {
        return AnnuusConfigCommand.createConfigNode(key, StringArgumentType::string, StringArgumentType::getString);
    }

    private static <X> LiteralArgumentBuilder<CommandSourceStack> createConfigNode(AnnuusConfigKey<X> key, Supplier<ArgumentType<X>> argumentType, BiFunction<CommandContext<CommandSourceStack>, String, X> argument) {
        String configName = key.name();
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)configName).executes(context -> {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.nullToEmpty((String)("Config '" + configName + "' is '" + String.valueOf(Annuus.CONFIG.getConfig(key)) + "' now")), false);
            return 0;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)configName, argumentType.get()).executes(context -> AnnuusConfigCommand.changeConfig((CommandContext<CommandSourceStack>)context, key, argument))).then(Commands.literal((String)"temporary").executes(context -> AnnuusConfigCommand.changeConfigTemporary((CommandContext<CommandSourceStack>)context, key, argument))));
    }
}

