/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.annuus.config;

import com.github.cao.awa.annuus.config.key.AnnuusConfigKey;
import com.github.cao.awa.annuus.information.compressor.InformationCompressor;
import com.github.cao.awa.annuus.information.compressor.bzip2.Bzip2Compressor;
import com.github.cao.awa.annuus.information.compressor.deflate.DeflateCompressor;
import com.github.cao.awa.annuus.information.compressor.inaction.InactionCompressor;
import com.github.cao.awa.annuus.information.compressor.lz4.Lz4Compressor;
import com.github.cao.awa.annuus.information.compressor.lzma.LZMACompressor;
import com.github.cao.awa.annuus.network.packet.client.play.block.update.CollectedBlockUpdatePayload;
import com.github.cao.awa.annuus.network.packet.client.play.chunk.data.CollectedChunkDataPayload;
import com.github.cao.awa.annuus.network.packet.client.play.chunk.update.CollectedChunkBlockUpdatePayload;
import com.github.cao.awa.annuus.network.packet.client.play.recipe.ShortRecipeSyncPayload;
import com.github.cao.awa.sinuatum.manipulate.Manipulate;
import com.github.cao.awa.sinuatum.util.collection.CollectionFactor;
import com.github.cao.awa.sinuatum.util.io.IOUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.util.GsonHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnuusConfig {
    private static final Logger LOGGER = LogManager.getLogger((String)"AnnuusConfig");
    private static final File CONFIG_FILE = new File("config/annuus.json");
    private static final Set<String> COMPRESS_OPTIONS = CollectionFactor.hashSet((Object[])new String[]{"no_compress", "best_compress", "best_speed", "deflate_1", "deflate_2", "deflate_3", "deflate_4", "deflate_5", "deflate_6", "deflate_7", "deflate_8", "deflate_9", "lz4", "bzip2", "lzma"});
    private static final Function<String, InformationCompressor> COMPRESSOR_FETCHER = compressOption -> {
        if (compressOption == null) {
            return DeflateCompressor.BEST_INSTANCE;
        }
        if (compressOption.startsWith("deflate_")) {
            return switch (compressOption.replace("deflate_", "")) {
                case "1" -> DeflateCompressor.FASTEST_INSTANCE;
                case "2" -> DeflateCompressor.DEFLATE_2_INSTANCE;
                case "3" -> DeflateCompressor.DEFLATE_3_INSTANCE;
                case "4" -> DeflateCompressor.DEFLATE_4_INSTANCE;
                case "5" -> DeflateCompressor.DEFLATE_5_INSTANCE;
                case "6" -> DeflateCompressor.DEFLATE_6_INSTANCE;
                case "7" -> DeflateCompressor.DEFLATE_7_INSTANCE;
                case "8" -> DeflateCompressor.DEFLATE_8_INSTANCE;
                case "9" -> DeflateCompressor.BEST_INSTANCE;
                default -> throw new IllegalStateException("Unexpected value: " + compressOption);
            };
        }
        if (compressOption.equals("lz4")) {
            return Lz4Compressor.INSTANCE;
        }
        if (compressOption.equals("bzip2")) {
            return Bzip2Compressor.INSTANCE;
        }
        if (compressOption.equals("lzma")) {
            return LZMACompressor.INSTANCE;
        }
        if (compressOption.equals("no_compress") || compressOption.equals("inaction")) {
            return InactionCompressor.INSTANCE;
        }
        return switch (compressOption) {
            case "best_compress" -> DeflateCompressor.BEST_INSTANCE;
            case "best_speed" -> DeflateCompressor.FASTEST_INSTANCE;
            default -> throw new IllegalStateException("Unexpected value: " + compressOption);
        };
    };
    public static final AnnuusConfigKey<String> CHUNK_COMPRESS = AnnuusConfigKey.create("chunk_compression", compressOption -> CollectedChunkDataPayload.setCurrentCompressor(COMPRESSOR_FETCHER.apply((String)compressOption)), "best_compress", COMPRESS_OPTIONS);
    public static final AnnuusConfigKey<String> BLOCK_UPDATES_COMPRESS = AnnuusConfigKey.create("block_updates_compression", compressOption -> {
        CollectedBlockUpdatePayload.setCurrentCompressor(COMPRESSOR_FETCHER.apply((String)compressOption));
        CollectedChunkBlockUpdatePayload.setCurrentCompressor(COMPRESSOR_FETCHER.apply((String)compressOption));
    }, "best_compress", COMPRESS_OPTIONS);
    public static final AnnuusConfigKey<Boolean> SHORT_RECIPES = AnnuusConfigKey.create("short_recipes", true);
    public static final AnnuusConfigKey<Boolean> ZIGZAG_VAR_INT = AnnuusConfigKey.create("zigzag_var_int", true);
    public static final AnnuusConfigKey<String> SHORT_RECIPES_COMPRESS = AnnuusConfigKey.create("short_recipes_compress", compressOption -> ShortRecipeSyncPayload.setCurrentCompressor(COMPRESSOR_FETCHER.apply((String)compressOption)), "best_compress", COMPRESS_OPTIONS);
    private final JsonObject config = new JsonObject();

    public boolean isEnableChunkCompress() {
        return !this.getConfig(CHUNK_COMPRESS).equals("no_compress");
    }

    public String chunkCompress() {
        return this.getConfig(CHUNK_COMPRESS);
    }

    public boolean isEnableBlockUpdatesCompress() {
        return !this.getConfig(BLOCK_UPDATES_COMPRESS).equals("no_compress");
    }

    public String blockUpdatesCompress() {
        return this.getConfig(BLOCK_UPDATES_COMPRESS);
    }

    public boolean isEnableShortRecipes() {
        return this.getConfig(SHORT_RECIPES);
    }

    public boolean isEnableShortRecipesCompress() {
        return !this.getConfig(SHORT_RECIPES_COMPRESS).equals("no_compress");
    }

    public String shortRecipesCompress() {
        return this.getConfig(SHORT_RECIPES_COMPRESS);
    }

    public <X> void setConfig(AnnuusConfigKey<X> configKey, X value) {
        this.config.add(configKey.name(), configKey.check(AnnuusConfig.check(configKey, value)));
    }

    public <X> void setConfig(AnnuusConfigKey<X> configKey, JsonObject json) {
        this.setConfig(configKey, AnnuusConfig.check(configKey, json.get(configKey.name())));
    }

    public <X> X getConfig(AnnuusConfigKey<X> configKey) {
        JsonElement value = this.config.get(configKey.name());
        if (value == null) {
            return configKey.defaultValue();
        }
        if (value instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)value;
            return configKey.getValue(primitive);
        }
        return AnnuusConfig.check(configKey, value);
    }

    @Nullable
    private static <X> X check(@NotNull AnnuusConfigKey<X> configKey, @Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)value;
            return configKey.getValue(primitive);
        }
        if (configKey.type().isInstance(value) || configKey.type().isAssignableFrom(value.getClass())) {
            return (X)Manipulate.cast((Object)value);
        }
        throw new IllegalArgumentException("Config key '" + configKey.name() + "' required '" + String.valueOf(configKey.type()) + "' but got '" + String.valueOf(value.getClass()) + "'");
    }

    public void load() {
        this.loadAsDefault();
        try {
            JsonObject config = GsonHelper.parse((String)IOUtil.read((Reader)new FileReader(CONFIG_FILE, StandardCharsets.UTF_8)));
            this.setConfig(CHUNK_COMPRESS, config);
            this.setConfig(BLOCK_UPDATES_COMPRESS, config);
            this.setConfig(SHORT_RECIPES, config);
            this.setConfig(SHORT_RECIPES_COMPRESS, config);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Config not found, will use default config values");
        }
        catch (Exception e) {
            LOGGER.warn("Happening unexpected exception, config system cannot resolve it, will use default config values", (Throwable)e);
        }
        this.write();
    }

    public void write() {
        try {
            if (!CONFIG_FILE.getParentFile().exists()) {
                CONFIG_FILE.getParentFile().mkdirs();
            }
            IOUtil.write((Writer)new FileWriter(CONFIG_FILE, StandardCharsets.UTF_8), (String)this.config.toString());
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save config", (Throwable)e);
        }
    }

    public void loadAsDefault() {
        this.setConfig(CHUNK_COMPRESS, CHUNK_COMPRESS.defaultValue());
        this.setConfig(BLOCK_UPDATES_COMPRESS, BLOCK_UPDATES_COMPRESS.defaultValue());
        this.setConfig(SHORT_RECIPES, SHORT_RECIPES.defaultValue());
        this.setConfig(SHORT_RECIPES_COMPRESS, SHORT_RECIPES_COMPRESS.defaultValue());
    }

    public void copyFrom(@NotNull AnnuusConfig config) {
        this.setConfig(CHUNK_COMPRESS, config.chunkCompress());
        this.setConfig(BLOCK_UPDATES_COMPRESS, config.blockUpdatesCompress());
        this.setConfig(SHORT_RECIPES, config.isEnableShortRecipes());
        this.setConfig(SHORT_RECIPES_COMPRESS, config.shortRecipesCompress());
    }

    public void print() {
        if (this.isEnableChunkCompress()) {
            LOGGER.info("Annuus is enabled chunk compression: {}", (Object)this.chunkCompress());
        }
        if (this.isEnableBlockUpdatesCompress()) {
            LOGGER.info("Annuus is enabled block updates compression: {}", (Object)this.blockUpdatesCompress());
        }
        if (this.isEnableShortRecipes()) {
            LOGGER.info("Annuus is enabled short recipes synchronize (replacement v1)");
        }
        if (this.isEnableShortRecipesCompress()) {
            LOGGER.info("Annuus is enabled short recipes synchronize compression: {}", (Object)this.shortRecipesCompress());
        }
    }

    public Set<AnnuusConfigKey<?>> collectEnabled() {
        HashSet enabled = CollectionFactor.hashSet();
        if (this.isEnableChunkCompress()) {
            enabled.add(CHUNK_COMPRESS);
        }
        if (this.isEnableBlockUpdatesCompress()) {
            enabled.add(BLOCK_UPDATES_COMPRESS);
        }
        if (this.isEnableShortRecipes()) {
            enabled.add(SHORT_RECIPES);
        }
        if (this.isEnableShortRecipesCompress()) {
            enabled.add(SHORT_RECIPES_COMPRESS);
        }
        return enabled;
    }
}

