/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.annuus.information.compressor.deflate;

import com.github.cao.awa.annuus.information.compressor.InformationCompressor;
import com.github.cao.awa.annuus.information.compressor.InformationCompressors;
import com.github.cao.awa.apricot.annotations.Stable;
import com.github.cao.awa.sinuatum.util.io.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

@Stable
public class DeflateCompressor
implements InformationCompressor {
    public static final DeflateCompressor BEST_INSTANCE = InformationCompressors.register(new DeflateCompressor(9));
    public static final DeflateCompressor DEFLATE_8_INSTANCE = InformationCompressors.register(new DeflateCompressor(8));
    public static final DeflateCompressor DEFLATE_7_INSTANCE = InformationCompressors.register(new DeflateCompressor(7));
    public static final DeflateCompressor DEFLATE_6_INSTANCE = InformationCompressors.register(new DeflateCompressor(6));
    public static final DeflateCompressor DEFLATE_5_INSTANCE = InformationCompressors.register(new DeflateCompressor(5));
    public static final DeflateCompressor DEFLATE_4_INSTANCE = InformationCompressors.register(new DeflateCompressor(4));
    public static final DeflateCompressor DEFLATE_3_INSTANCE = InformationCompressors.register(new DeflateCompressor(3));
    public static final DeflateCompressor DEFLATE_2_INSTANCE = InformationCompressors.register(new DeflateCompressor(2));
    public static final DeflateCompressor FASTEST_INSTANCE = InformationCompressors.register(new DeflateCompressor(1));
    private final int compressLevel;

    public DeflateCompressor(int compressLevel) {
        this.compressLevel = compressLevel;
    }

    @Override
    public int getId() {
        return this.compressLevel;
    }

    @Override
    public byte[] compress(byte[] bytes) {
        byte[] byArray;
        if (bytes.length == 0) {
            return EMPTY_BYTES;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IOUtil.write((OutputStream)new DeflaterOutputStream((OutputStream)out, new Deflater(this.compressLevel)), (byte[])bytes);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return bytes;
            }
        }
        out.close();
        return byArray;
    }

    @Override
    public byte[] decompress(byte[] bytes) {
        byte[] byArray;
        if (bytes.length == 0) {
            return EMPTY_BYTES;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            InflaterInputStream inflater = new InflaterInputStream(new ByteArrayInputStream(bytes));
            IOUtil.write((OutputStream)result, (InputStream)inflater);
            byArray = result.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    result.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                return bytes;
            }
        }
        result.close();
        return byArray;
    }
}

