/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.annuus.information.compressor.lzma;

import com.github.cao.awa.annuus.information.compressor.InformationCompressor;
import com.github.cao.awa.annuus.information.compressor.InformationCompressors;
import com.github.cao.awa.apricot.annotations.Stable;
import com.github.cao.awa.sinuatum.util.io.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.lzma.LZMACompressorInputStream;
import org.apache.commons.compress.compressors.lzma.LZMACompressorOutputStream;

@Stable
public class LZMACompressor
implements InformationCompressor {
    public static final LZMACompressor INSTANCE = InformationCompressors.register(new LZMACompressor());

    @Override
    public int getId() {
        return 11;
    }

    @Override
    public byte[] compress(byte[] bytes) {
        byte[] byArray;
        if (bytes.length == 0) {
            return EMPTY_BYTES;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IOUtil.write((OutputStream)new LZMACompressorOutputStream((OutputStream)out), (byte[])bytes);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return bytes;
            }
        }
        out.close();
        return byArray;
    }

    @Override
    public byte[] decompress(byte[] bytes) {
        byte[] byArray;
        if (bytes.length == 0) {
            return EMPTY_BYTES;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            IOUtil.write((OutputStream)result, (InputStream)new LZMACompressorInputStream((InputStream)new ByteArrayInputStream(bytes)));
            byArray = result.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    result.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                return bytes;
            }
        }
        result.close();
        return byArray;
    }
}

