/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.annuus.mixin.network.connection;

import com.github.cao.awa.annuus.Annuus;
import com.github.cao.awa.annuus.chunk.update.ChunkBlockUpdateDetails;
import com.github.cao.awa.annuus.information.compressor.InformationCompressor;
import com.github.cao.awa.annuus.information.compressor.bzip2.Bzip2Compressor;
import com.github.cao.awa.annuus.information.compressor.deflate.DeflateCompressor;
import com.github.cao.awa.annuus.information.compressor.lzma.LZMACompressor;
import com.github.cao.awa.annuus.mixin.server.network.packet.chunk.delta.ChunkDeltaUpdateS2CPacketAccessor;
import com.github.cao.awa.annuus.network.packet.client.play.block.update.CollectedBlockUpdatePayload;
import com.github.cao.awa.annuus.network.packet.client.play.chunk.data.CollectedChunkDataPayload;
import com.github.cao.awa.annuus.network.packet.client.play.chunk.update.CollectedChunkBlockUpdatePayload;
import com.github.cao.awa.annuus.server.AnnuusServer;
import it.unimi.dsi.fastutil.longs.Long2ObjectRBTreeMap;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Connection.class})
public abstract class ClientConnectionMixin {
    @Unique
    private Map<Long, BlockState> blockUpdates = new Long2ObjectRBTreeMap();
    @Unique
    private Map<Long, ChunkBlockUpdateDetails> chunkUpdates = new Long2ObjectRBTreeMap();

    @Shadow
    public abstract void send(Packet<?> var1);

    @Inject(method={"send(Lnet/minecraft/network/protocol/Packet;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void collectBlockUpdate(Packet<?> packet, CallbackInfo ci) {
        if (Annuus.isServer && AnnuusServer.getAnnuusVersion(this) >= 3 && Annuus.CONFIG.isEnableBlockUpdatesCompress()) {
            boolean shouldCancel = false;
            if (packet instanceof ClientboundBlockUpdatePacket) {
                ClientboundBlockUpdatePacket blockUpdatePacket = (ClientboundBlockUpdatePacket)packet;
                this.blockUpdates.put(blockUpdatePacket.getPos().asLong(), blockUpdatePacket.getBlockState());
                shouldCancel = true;
            }
            if (packet instanceof ClientboundSectionBlocksUpdatePacket) {
                ClientboundSectionBlocksUpdatePacket chunkDeltaUpdatePacket = (ClientboundSectionBlocksUpdatePacket)packet;
                ChunkDeltaUpdateS2CPacketAccessor accessor = (ChunkDeltaUpdateS2CPacketAccessor)chunkDeltaUpdatePacket;
                this.chunkUpdates.put(accessor.getChunkSectionpos().asLong(), new ChunkBlockUpdateDetails(accessor.getPosArray(), Arrays.stream(accessor.getStateArray()).mapToInt(Block::getId).toArray()));
                shouldCancel = true;
            }
            if (shouldCancel) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    public void sendCollectedBlockUpdates(CallbackInfo ci) {
        InformationCompressor informationCompressor = CollectedChunkBlockUpdatePayload.getCurrentCompressor();
        if ((CollectedChunkDataPayload.getCurrentCompressor() instanceof Bzip2Compressor || CollectedChunkDataPayload.getCurrentCompressor() instanceof LZMACompressor) && AnnuusServer.getAnnuusVersion(this) < 5) {
            CollectedChunkBlockUpdatePayload.setCurrentCompressor(DeflateCompressor.BEST_INSTANCE);
        }
        if (!this.blockUpdates.isEmpty()) {
            this.send((Packet<?>)CollectedBlockUpdatePayload.createPacket((Map<Long, BlockState>)new Long2ObjectRBTreeMap(this.blockUpdates)));
            this.blockUpdates.clear();
        }
        if (!this.chunkUpdates.isEmpty()) {
            this.send((Packet<?>)CollectedChunkBlockUpdatePayload.createPacket((Map<Long, ChunkBlockUpdateDetails>)new Long2ObjectRBTreeMap(this.chunkUpdates)));
            this.chunkUpdates.clear();
        }
        CollectedChunkBlockUpdatePayload.setCurrentCompressor(informationCompressor);
    }
}

