/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.annuus.mixin.player.manager;

import com.github.cao.awa.annuus.Annuus;
import com.github.cao.awa.annuus.information.compressor.InformationCompressor;
import com.github.cao.awa.annuus.information.compressor.bzip2.Bzip2Compressor;
import com.github.cao.awa.annuus.information.compressor.deflate.DeflateCompressor;
import com.github.cao.awa.annuus.information.compressor.lzma.LZMACompressor;
import com.github.cao.awa.annuus.network.packet.client.play.chunk.data.CollectedChunkDataPayload;
import com.github.cao.awa.annuus.network.packet.client.play.chunk.update.CollectedChunkBlockUpdatePayload;
import com.github.cao.awa.annuus.network.packet.client.play.recipe.ShortRecipeSyncPayload;
import com.github.cao.awa.annuus.network.packet.client.update.NoticeUpdateServerAnnuusPayload;
import com.github.cao.awa.annuus.server.AnnuusServer;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SelectableRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerList.class})
public class PlayerManagerMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AnnuusPlayerManager");
    @Shadow
    @Final
    private MinecraftServer server;

    /*
     * Enabled aggressive block sorting
     */
    @WrapOperation(method={"placeNewPlayer(Lnet/minecraft/network/Connection;Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/network/CommonListenerCookie;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayNetworkHandler;sendPacket(Lnet/minecraft/network/packet/Packet;)V", ordinal=4)})
    public void redirectSyncRecipes(ServerGamePacketListenerImpl instance, Packet<?> packet, Operation<Void> original) {
        boolean canUseShortRecipes;
        int annuusProtocolVersion = AnnuusServer.getAnnuusVersion(instance);
        boolean bl = canUseShortRecipes = annuusProtocolVersion >= 4 && Annuus.CONFIG.isEnableShortRecipes();
        if (packet instanceof ClientboundUpdateRecipesPacket) {
            ClientboundUpdateRecipesPacket source = (ClientboundUpdateRecipesPacket)packet;
            if (canUseShortRecipes) {
                RecipeManager recipeManager = this.server.getRecipeManager();
                ShortRecipeSyncPayload payload = ShortRecipeSyncPayload.createData(recipeManager.getSynchronizedItemProperties(), (SelectableRecipe.SingleInputSet<StonecutterRecipe>)recipeManager.getSynchronizedStonecutterRecipes());
                InformationCompressor informationCompressor = CollectedChunkBlockUpdatePayload.getCurrentCompressor();
                if ((CollectedChunkDataPayload.getCurrentCompressor() instanceof Bzip2Compressor || CollectedChunkDataPayload.getCurrentCompressor() instanceof LZMACompressor) && AnnuusServer.getAnnuusVersion(this) < 5) {
                    ShortRecipeSyncPayload.setCurrentCompressor(DeflateCompressor.BEST_INSTANCE);
                }
                ClientboundCustomPayloadPacket shortRecipeSyncPayloadPacket = ShortRecipeSyncPayload.createPacket(payload);
                instance.sendPacket((Packet)shortRecipeSyncPayloadPacket);
                ShortRecipeSyncPayload.setCurrentCompressor(informationCompressor);
                return;
            }
        }
        original.call(new Object[]{instance, packet});
    }

    @Inject(method={"placeNewPlayer(Lnet/minecraft/network/Connection;Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/network/CommonListenerCookie;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayNetworkHandler;sendPacket(Lnet/minecraft/network/packet/Packet;)V", ordinal=0, shift=At.Shift.AFTER)})
    public void requireClientAnnuusVersion(Connection connection, ServerPlayer player, CommonListenerCookie clientData, CallbackInfo ci) {
        connection.send((Packet)NoticeUpdateServerAnnuusPayload.createPacket());
    }

    @Inject(method={"placeNewPlayer(Lnet/minecraft/network/Connection;Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/network/CommonListenerCookie;)V"}, at={@At(value="HEAD")})
    public void onReady(Connection connection, ServerPlayer player, CommonListenerCookie clientData, CallbackInfo ci) {
        int annuusVersion = AnnuusServer.getAnnuusVersion(connection);
        if (annuusVersion > -1) {
            LOGGER.info("Player {} joining server with Annuus protocol version {}", (Object)player.getName().getString(), (Object)annuusVersion);
        }
    }
}

