/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.annuus.mixin.server.network.packet.chunk.sender;

import com.github.cao.awa.annuus.Annuus;
import com.github.cao.awa.annuus.information.compressor.bzip2.Bzip2Compressor;
import com.github.cao.awa.annuus.information.compressor.lzma.LZMACompressor;
import com.github.cao.awa.annuus.network.packet.client.play.chunk.data.CollectedChunkDataPayload;
import com.github.cao.awa.annuus.server.AnnuusServer;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChunkBatchFinishedPacket;
import net.minecraft.network.protocol.game.ClientboundChunkBatchStartPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.PlayerChunkSender;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerChunkSender.class})
public class ChunkDataSenderMixin {
    @Shadow
    private int unacknowledgedBatches;
    @Shadow
    private float batchQuota;
    @Unique
    private ServerPlayer player;
    @Unique
    private static long start = 0L;

    @Inject(method={"sendNextChunks(Lnet/minecraft/server/level/ServerPlayer;)V"}, at={@At(value="HEAD")})
    public void sendChunkBatches(ServerPlayer player, CallbackInfo ci) {
        this.player = player;
    }

    @WrapOperation(method={"sendNextChunks(Lnet/minecraft/server/level/ServerPlayer;)V"}, at={@At(value="INVOKE", target="Ljava/util/List;isEmpty()Z")})
    public boolean sendChunkBatches(List<LevelChunk> list, Operation<Boolean> original) {
        if (Annuus.isServer && AnnuusServer.getAnnuusVersion(this.player) >= 3 && Annuus.CONFIG.isEnableChunkCompress()) {
            if ((CollectedChunkDataPayload.getCurrentCompressor() instanceof Bzip2Compressor || CollectedChunkDataPayload.getCurrentCompressor() instanceof LZMACompressor) && AnnuusServer.getAnnuusVersion(this.player) < 5) {
                original.call(new Object[]{list});
                return true;
            }
            if (!list.isEmpty()) {
                ServerLevel world = this.player.level();
                ServerGamePacketListenerImpl networkHandler = this.player.connection;
                ++this.unacknowledgedBatches;
                LevelChunk[] sendingChunks = (LevelChunk[])list.toArray(LevelChunk[]::new);
                networkHandler.send((Packet)ClientboundChunkBatchStartPacket.INSTANCE, null);
                networkHandler.send((Packet)CollectedChunkDataPayload.createPacket(sendingChunks, world.getLightEngine()), null);
                networkHandler.send((Packet)new ClientboundChunkBatchFinishedPacket(list.size()), null);
                this.batchQuota -= (float)list.size();
            }
            return true;
        }
        return (Boolean)original.call(new Object[]{list});
    }
}

