/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.annuus.network.packet.client.play.block.update;

import com.github.cao.awa.annuus.information.compressor.InformationCompressor;
import com.github.cao.awa.annuus.information.compressor.deflate.DeflateCompressor;
import com.github.cao.awa.annuus.util.compress.AnnuusCompressUtil;
import com.github.cao.awa.sinuatum.util.collection.CollectionFactor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public record CollectedBlockUpdatePayload(Map<Long, BlockState> committed) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CollectedBlockUpdatePayload> IDENTIFIER = new CustomPacketPayload.Type(ResourceLocation.parse((String)"annuus:collected_blocks"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CollectedBlockUpdatePayload> CODEC = StreamCodec.of(CollectedBlockUpdatePayload::encode, CollectedBlockUpdatePayload::decode);
    private static InformationCompressor currentCompressor = DeflateCompressor.BEST_INSTANCE;

    public static void setCurrentCompressor(InformationCompressor compressor) {
        currentCompressor = compressor;
    }

    public static ClientboundCustomPayloadPacket createPacket(Map<Long, BlockState> updates) {
        return new ClientboundCustomPayloadPacket((CustomPacketPayload)CollectedBlockUpdatePayload.createData(updates));
    }

    public static CollectedBlockUpdatePayload createData(Map<Long, BlockState> updates) {
        return new CollectedBlockUpdatePayload(updates);
    }

    private static CollectedBlockUpdatePayload decode(RegistryFriendlyByteBuf buf) {
        try {
            RegistryFriendlyByteBuf delegate = AnnuusCompressUtil.decompressRegistryBuf(buf);
            int size = delegate.readVarInt();
            long[] positions = new long[size];
            BlockState[] states = new BlockState[size];
            for (int i = 0; i < size; ++i) {
                positions[i] = delegate.readVarLong();
            }
            StreamCodec blockStateCodec = ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY);
            for (int i = 0; i < size; ++i) {
                states[i] = (BlockState)blockStateCodec.decode((Object)delegate);
            }
            HashMap committed = CollectionFactor.hashMap();
            for (int i = 0; i < size; ++i) {
                committed.put(positions[i], states[i]);
            }
            return new CollectedBlockUpdatePayload(committed);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private static void encode(RegistryFriendlyByteBuf buf, CollectedBlockUpdatePayload packet) {
        RegistryFriendlyByteBuf delegate = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.buffer()), buf.registryAccess());
        int size = packet.committed.size();
        delegate.writeVarInt(size);
        for (long position : packet.committed.keySet()) {
            delegate.writeVarLong(position);
        }
        StreamCodec blockStateCodec = ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY);
        for (BlockState blockState : packet.committed.values()) {
            blockStateCodec.encode((Object)delegate, (Object)blockState);
        }
        AnnuusCompressUtil.compress((FriendlyByteBuf)buf, (FriendlyByteBuf)delegate, () -> currentCompressor);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return IDENTIFIER;
    }
}

