/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.annuus.network.packet.client.play.chunk.data;

import com.github.cao.awa.annuus.information.compressor.InformationCompressor;
import com.github.cao.awa.annuus.information.compressor.deflate.DeflateCompressor;
import com.github.cao.awa.annuus.util.compress.AnnuusCompressUtil;
import com.github.cao.awa.sinuatum.util.collection.CollectionFactor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacketData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record CollectedChunkDataPayload(IntList xPositions, IntList zPositions, List<ClientboundLevelChunkPacketData> chunkData, List<ClientboundLightUpdatePacketData> lightData) implements CustomPacketPayload
{
    private static final Logger LOGGER = LogManager.getLogger((String)"AnnuusCollectdChunkDataPayload");
    public static final CustomPacketPayload.Type<CollectedChunkDataPayload> IDENTIFIER = new CustomPacketPayload.Type(ResourceLocation.parse((String)"annuus:collected_chunk"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CollectedChunkDataPayload> CODEC = StreamCodec.of(CollectedChunkDataPayload::encode, CollectedChunkDataPayload::decode);
    private static InformationCompressor currentCompressor = DeflateCompressor.BEST_INSTANCE;

    public static void setCurrentCompressor(InformationCompressor compressor) {
        currentCompressor = compressor;
    }

    public static InformationCompressor getCurrentCompressor() {
        return currentCompressor;
    }

    public static ClientboundCustomPayloadPacket createPacket(LevelChunk[] chunks, LevelLightEngine lightProvider) {
        return new ClientboundCustomPayloadPacket((CustomPacketPayload)CollectedChunkDataPayload.createData(chunks, lightProvider));
    }

    public static CollectedChunkDataPayload createData(LevelChunk[] chunks, LevelLightEngine lightProvider) {
        IntArrayList xPositions = new IntArrayList();
        IntArrayList zPositions = new IntArrayList();
        ArrayList chunksData = CollectionFactor.arrayList();
        ArrayList lightsData = CollectionFactor.arrayList();
        for (LevelChunk chunk : chunks) {
            ChunkPos chunkPos = chunk.getPos();
            xPositions.add(chunkPos.x);
            zPositions.add(chunkPos.z);
            chunksData.add(new ClientboundLevelChunkPacketData(chunk));
            lightsData.add(new ClientboundLightUpdatePacketData(chunkPos, lightProvider, null, null));
        }
        return new CollectedChunkDataPayload((IntList)xPositions, (IntList)zPositions, chunksData, lightsData);
    }

    private static CollectedChunkDataPayload decode(RegistryFriendlyByteBuf buf) {
        try {
            int i;
            RegistryFriendlyByteBuf delegate = AnnuusCompressUtil.decompressRegistryBuf(buf);
            int size = delegate.readVarInt();
            IntArrayList xPositions = new IntArrayList();
            IntArrayList zPositions = new IntArrayList();
            for (i = 0; i < size; ++i) {
                xPositions.add(delegate.readVarInt());
            }
            for (i = 0; i < size; ++i) {
                zPositions.add(delegate.readVarInt());
            }
            ArrayList chunkDataList = CollectionFactor.arrayList();
            for (int i2 = 0; i2 < size; ++i2) {
                int chunkX = xPositions.getInt(i2);
                int chunkZ = zPositions.getInt(i2);
                chunkDataList.add(new ClientboundLevelChunkPacketData(delegate, chunkX, chunkZ));
            }
            ArrayList lightDataList = CollectionFactor.arrayList();
            for (int i3 = 0; i3 < size; ++i3) {
                int chunkX = xPositions.getInt(i3);
                int chunkZ = zPositions.getInt(i3);
                lightDataList.add(new ClientboundLightUpdatePacketData((FriendlyByteBuf)delegate, chunkX, chunkZ));
            }
            return new CollectedChunkDataPayload((IntList)xPositions, (IntList)zPositions, chunkDataList, lightDataList);
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw e;
        }
    }

    private static void encode(RegistryFriendlyByteBuf buf, CollectedChunkDataPayload packet) {
        int position;
        RegistryFriendlyByteBuf delegate = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.buffer()), buf.registryAccess());
        int size = packet.chunkData.size();
        delegate.writeVarInt(size);
        Object object = packet.xPositions.iterator();
        while (object.hasNext()) {
            position = (Integer)object.next();
            delegate.writeVarInt(position);
        }
        object = packet.zPositions.iterator();
        while (object.hasNext()) {
            position = (Integer)object.next();
            delegate.writeVarInt(position);
        }
        for (ClientboundLevelChunkPacketData chunkData : packet.chunkData) {
            chunkData.write(delegate);
        }
        for (ClientboundLightUpdatePacketData lightData : packet.lightData) {
            lightData.write((FriendlyByteBuf)delegate);
        }
        AnnuusCompressUtil.compress((FriendlyByteBuf)buf, (FriendlyByteBuf)delegate, () -> currentCompressor);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return IDENTIFIER;
    }
}

