/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.annuus.network.packet.client.play.chunk.data;

import com.github.cao.awa.annuus.network.packet.client.play.chunk.data.CollectedChunkDataPayload;
import com.github.cao.awa.sinuatum.function.exception.consumer.ExceptingConsumer;
import com.github.cao.awa.sinuatum.manipulate.Manipulate;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.Serializable;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacketData;

public class CollectedChunkDataPayloadHandler {
    public static void loadChunksFromPayload(CollectedChunkDataPayload payload, Minecraft client, LocalPlayer player) {
        ClientPacketListener networkHandler = player.connection;
        ClientLevel world = networkHandler.getLevel();
        RegistryFriendlyByteBuf delegateBuf = (RegistryFriendlyByteBuf)Manipulate.make((Object)new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.buffer()), world.registryAccess()), (ExceptingConsumer & Serializable)buf -> {
            Iterator<ClientboundLevelChunkPacketData> chunkDataIterator = payload.chunkData().iterator();
            Iterator<ClientboundLightUpdatePacketData> lightDataIterator = payload.lightData().iterator();
            IntList xPositions = payload.xPositions();
            IntList zPositions = payload.zPositions();
            int i = 0;
            while (chunkDataIterator.hasNext()) {
                buf.writeInt(xPositions.getInt(i));
                buf.writeInt(zPositions.getInt(i));
                chunkDataIterator.next().write(buf);
                lightDataIterator.next().write((FriendlyByteBuf)buf);
                ++i;
            }
        });
        while (delegateBuf.readableBytes() > 0) {
            networkHandler.handleLevelChunkWithLight((ClientboundLevelChunkWithLightPacket)ClientboundLevelChunkWithLightPacket.STREAM_CODEC.decode((Object)delegateBuf));
        }
    }
}

