/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.annuus.network.packet.client.play.chunk.update;

import com.github.cao.awa.annuus.chunk.update.ChunkBlockUpdateDetails;
import com.github.cao.awa.annuus.information.compressor.InformationCompressor;
import com.github.cao.awa.annuus.information.compressor.deflate.DeflateCompressor;
import com.github.cao.awa.annuus.util.compress.AnnuusCompressUtil;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.Long2ObjectRBTreeMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.SectionPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public record CollectedChunkBlockUpdatePayload(Map<Long, ChunkBlockUpdateDetails> details) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CollectedChunkBlockUpdatePayload> IDENTIFIER = new CustomPacketPayload.Type(ResourceLocation.parse((String)"annuus:collected_chunk_blocks"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CollectedChunkBlockUpdatePayload> CODEC = StreamCodec.of(CollectedChunkBlockUpdatePayload::encode, CollectedChunkBlockUpdatePayload::decode);
    private static InformationCompressor currentCompressor = DeflateCompressor.BEST_INSTANCE;

    public static void setCurrentCompressor(InformationCompressor compressor) {
        currentCompressor = compressor;
    }

    public static InformationCompressor getCurrentCompressor() {
        return currentCompressor;
    }

    public static ClientboundCustomPayloadPacket createPacket(SectionPos sectionPos, short[] positions, BlockState[] updates) {
        Long2ObjectRBTreeMap details = new Long2ObjectRBTreeMap();
        details.put(sectionPos.asLong(), new ChunkBlockUpdateDetails(positions, Arrays.stream(updates).mapToInt(Block::getId).toArray()));
        return CollectedChunkBlockUpdatePayload.createPacket((Map<Long, ChunkBlockUpdateDetails>)details);
    }

    public static ClientboundCustomPayloadPacket createPacket(Map<Long, ChunkBlockUpdateDetails> details) {
        return new ClientboundCustomPayloadPacket((CustomPacketPayload)CollectedChunkBlockUpdatePayload.createData(details));
    }

    public static CollectedChunkBlockUpdatePayload createData(SectionPos sectionPos, short[] positions, BlockState[] updates) {
        Long2ObjectRBTreeMap details = new Long2ObjectRBTreeMap();
        details.put(sectionPos.asLong(), new ChunkBlockUpdateDetails(positions, Arrays.stream(updates).mapToInt(Block::getId).toArray()));
        return new CollectedChunkBlockUpdatePayload((Map<Long, ChunkBlockUpdateDetails>)details);
    }

    public static CollectedChunkBlockUpdatePayload createData(Map<Long, ChunkBlockUpdateDetails> details) {
        return new CollectedChunkBlockUpdatePayload(details);
    }

    private static CollectedChunkBlockUpdatePayload decode(FriendlyByteBuf buf) {
        try {
            FriendlyByteBuf delegate = AnnuusCompressUtil.decompress(buf);
            int chunks = delegate.readVarInt();
            long[] chunkPositions = new long[chunks];
            for (int i = 0; i < chunks; ++i) {
                chunkPositions[i] = delegate.readVarLong();
            }
            int[] updates = new int[chunks];
            for (int i = 0; i < chunks; ++i) {
                updates[i] = delegate.readVarInt();
            }
            short[][] updatePositions = new short[chunks][];
            for (int i = 0; i < chunks; ++i) {
                updatePositions[i] = new short[updates[i]];
                for (int posIndex = 0; posIndex < updates[i]; ++posIndex) {
                    updatePositions[i][posIndex] = delegate.readShort();
                }
            }
            int[][] updateStates = new int[chunks][];
            for (int i = 0; i < chunks; ++i) {
                updateStates[i] = new int[updates[i]];
                for (int stateIndex = 0; stateIndex < updates[i]; ++stateIndex) {
                    updateStates[i][stateIndex] = delegate.readVarInt();
                }
            }
            Long2ObjectRBTreeMap details = new Long2ObjectRBTreeMap();
            int i = 0;
            for (long chunkPosition : chunkPositions) {
                details.put(chunkPosition, new ChunkBlockUpdateDetails(updatePositions[i], updateStates[i]));
                ++i;
            }
            return CollectedChunkBlockUpdatePayload.createData((Map<Long, ChunkBlockUpdateDetails>)details);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private static void encode(FriendlyByteBuf buf, CollectedChunkBlockUpdatePayload packet) {
        FriendlyByteBuf delegate = new FriendlyByteBuf(Unpooled.buffer());
        Set<Long> chunks = packet.details.keySet();
        int size = chunks.size();
        delegate.writeVarInt(size);
        for (long chunkPos : chunks) {
            delegate.writeVarLong(chunkPos);
        }
        Collection<ChunkBlockUpdateDetails> updateDetails = packet.details.values();
        for (ChunkBlockUpdateDetails updateDetail : updateDetails) {
            delegate.writeVarInt(updateDetail.positions().length);
        }
        for (ChunkBlockUpdateDetails updateDetail : updateDetails) {
            for (short position : updateDetail.positions()) {
                delegate.writeShort((int)position);
            }
        }
        for (ChunkBlockUpdateDetails updateDetail : updateDetails) {
            for (int states : updateDetail.states()) {
                delegate.writeVarInt(states);
            }
        }
        AnnuusCompressUtil.compress(buf, delegate, () -> currentCompressor);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return IDENTIFIER;
    }
}

