/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.annuus.network.packet.client.play.recipe;

import com.github.cao.awa.annuus.information.compressor.InformationCompressor;
import com.github.cao.awa.annuus.information.compressor.deflate.DeflateCompressor;
import com.github.cao.awa.annuus.recipe.AnnuusRecipeEntries;
import com.github.cao.awa.annuus.util.compress.AnnuusCompressUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.SelectableRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record ShortRecipeSyncPayload(AnnuusRecipeEntries recipes) implements CustomPacketPayload
{
    private static final Logger LOGGER = LogManager.getLogger((String)"AnnuusShortRecipeSyncPayload");
    public static final CustomPacketPayload.Type<ShortRecipeSyncPayload> IDENTIFIER = new CustomPacketPayload.Type(ResourceLocation.parse((String)"annuus:short_recipe_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ShortRecipeSyncPayload> CODEC = StreamCodec.of(ShortRecipeSyncPayload::encode, ShortRecipeSyncPayload::decode);
    private static InformationCompressor currentCompressor = DeflateCompressor.BEST_INSTANCE;

    public static void setCurrentCompressor(InformationCompressor compressor) {
        currentCompressor = compressor;
    }

    public static InformationCompressor getCurrentCompressor() {
        return currentCompressor;
    }

    public static ClientboundCustomPayloadPacket createPacket(Map<ResourceKey<RecipePropertySet>, RecipePropertySet> propertySetMap, SelectableRecipe.SingleInputSet<StonecutterRecipe> stonecuttingRecipeGrouping) {
        return new ClientboundCustomPayloadPacket((CustomPacketPayload)ShortRecipeSyncPayload.createData(propertySetMap, stonecuttingRecipeGrouping));
    }

    public static ClientboundCustomPayloadPacket createPacket(ShortRecipeSyncPayload payload) {
        return new ClientboundCustomPayloadPacket((CustomPacketPayload)payload);
    }

    public static ShortRecipeSyncPayload createData(Map<ResourceKey<RecipePropertySet>, RecipePropertySet> propertySetMap, SelectableRecipe.SingleInputSet<StonecutterRecipe> stonecuttingRecipeGrouping) {
        return new ShortRecipeSyncPayload(AnnuusRecipeEntries.create(propertySetMap, stonecuttingRecipeGrouping));
    }

    public static ShortRecipeSyncPayload createData(AnnuusRecipeEntries recipes) {
        return new ShortRecipeSyncPayload(recipes);
    }

    public static ShortRecipeSyncPayload decode(RegistryFriendlyByteBuf buf) {
        try {
            RegistryFriendlyByteBuf delegate = AnnuusCompressUtil.decompressRegistryBuf(buf);
            AnnuusRecipeEntries recipes = AnnuusRecipeEntries.decode(delegate);
            return ShortRecipeSyncPayload.createData(recipes);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void encode(RegistryFriendlyByteBuf buf, ShortRecipeSyncPayload packet) {
        RegistryFriendlyByteBuf delegate = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.buffer()), buf.registryAccess());
        AnnuusRecipeEntries.encode(delegate, packet.recipes);
        AnnuusCompressUtil.compress((FriendlyByteBuf)buf, (FriendlyByteBuf)delegate, () -> currentCompressor);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return IDENTIFIER;
    }
}

