/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.annuus.recipe;

import com.github.cao.awa.annuus.mixin.registry.RegistryKeyAccessor;
import com.github.cao.awa.annuus.recipe.AnnuusRecipeEntries;
import com.github.cao.awa.sinuatum.util.collection.CollectionFactor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.SelectableRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;

public class AnnuusRecipeReplacementV1 {
    public static void encode(Map<String, Integer> replacements, Map<ResourceKey<RecipePropertySet>, RecipePropertySet> propertySetMap, SelectableRecipe.SingleInputSet<StonecutterRecipe> stonecuttingRecipeGrouping, RegistryFriendlyByteBuf delegate) {
        delegate.writeMap(replacements, FriendlyByteBuf::writeUtf, FriendlyByteBuf::writeInt);
        delegate.writeVarInt(propertySetMap.size());
        propertySetMap.forEach((key, property) -> {
            delegate.writeResourceLocation(key.registry());
            delegate.writeResourceLocation(key.location());
            RecipePropertySet.STREAM_CODEC.encode((Object)delegate, property);
        });
        List stoneCuttingEntries = stonecuttingRecipeGrouping.entries();
        delegate.writeVarInt(stoneCuttingEntries.size());
        for (SelectableRecipe.SingleInputEntry stoneCuttingEntry : stoneCuttingEntries) {
            SelectableRecipe.SingleInputEntry.noRecipeCodec().encode((Object)delegate, (Object)stoneCuttingEntry);
        }
    }

    public static AnnuusRecipeEntries decode(RegistryFriendlyByteBuf delegate) {
        Map replacements = delegate.readMap(FriendlyByteBuf::readUtf, FriendlyByteBuf::readInt);
        int propertiesSize = delegate.readVarInt();
        HashMap propertySetMap = CollectionFactor.hashMap();
        for (int i = 0; i < propertiesSize; ++i) {
            ResourceLocation registry = delegate.readResourceLocation();
            ResourceLocation value = delegate.readResourceLocation();
            propertySetMap.put(RegistryKeyAccessor.ofIdentifier(registry, value), (RecipePropertySet)RecipePropertySet.STREAM_CODEC.decode((Object)delegate));
        }
        int stoneCuttingSize = delegate.readVarInt();
        ArrayList stoneCuttingRecipes = CollectionFactor.arrayList((int)stoneCuttingSize);
        for (int i = 0; i < stoneCuttingSize; ++i) {
            stoneCuttingRecipes.add((SelectableRecipe.SingleInputEntry)SelectableRecipe.SingleInputEntry.noRecipeCodec().decode((Object)delegate));
        }
        SelectableRecipe.SingleInputSet stonecuttingRecipeGrouping = new SelectableRecipe.SingleInputSet((List)stoneCuttingRecipes);
        return new AnnuusRecipeEntries(replacements, propertySetMap, (SelectableRecipe.SingleInputSet<StonecutterRecipe>)stonecuttingRecipeGrouping);
    }
}

