/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.annuus.server;

import com.github.cao.awa.annuus.mixin.server.network.handler.ServerCommonNetworkHandlerAccessor;
import com.github.cao.awa.annuus.version.storage.AnnuusVersionStorage;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.network.Connection;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import org.jetbrains.annotations.NotNull;

public class AnnuusServer {
    private static PlayerList playerManager;
    private static final AnnuusVersionStorage annuusVersions;

    public static void setupServerPlayerManager(@NotNull PlayerList playerManager) {
        AnnuusServer.playerManager = playerManager;
    }

    public static int getAnnuusVersion(@NotNull Object target) {
        return annuusVersions.getAnnuusVersion(AnnuusServer.convertToStandardConnection(target));
    }

    public static int setAnnuusVersion(@NotNull Object target, int version) {
        return annuusVersions.setAnnuusVersion(AnnuusServer.convertToStandardConnection(target), version);
    }

    private static Connection convertToStandardConnection(Object target) {
        Object object = target;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ServerCommonPacketListenerImpl.class, ServerPlayer.class, Connection.class}, (Object)object2, n)) {
            case 0 -> {
                ServerCommonPacketListenerImpl handler = (ServerCommonPacketListenerImpl)object2;
                yield ((ServerCommonNetworkHandlerAccessor)handler).getConnection();
            }
            case 1 -> {
                ServerPlayer player = (ServerPlayer)object2;
                yield ((ServerCommonNetworkHandlerAccessor)player.connection).getConnection();
            }
            case 2 -> {
                Connection connection;
                yield connection = (Connection)object2;
            }
            default -> throw new UnsupportedOperationException("Cannot convert object '" + String.valueOf(target) + "' to the standard key");
        };
    }

    static {
        annuusVersions = new AnnuusVersionStorage();
    }
}

