/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.annuus.util.bytes;

import com.github.cao.awa.annuus.util.bytes.BytesUtil;

public class BytesReader {
    private int flag = 0;
    private byte[] bytes;
    private int cursor = 0;

    private BytesReader(byte[] bytes) {
        this.bytes = bytes == null ? BytesUtil.EMPTY : bytes;
    }

    public static BytesReader of(byte[] bytes) {
        return new BytesReader(bytes);
    }

    public int getCursor() {
        return this.cursor;
    }

    public byte[] reverseRound(int round, int length) {
        return BytesUtil.reverseRound(this.read(length), round);
    }

    public byte[] read(int length) {
        if (length == 0) {
            return BytesUtil.EMPTY;
        }
        if (length + this.cursor > this.bytes.length) {
            this.cursor += length;
            return new byte[length];
        }
        byte[] result = new byte[length];
        System.arraycopy(this.bytes, this.cursor, result, 0, result.length);
        this.cursor += length;
        return result;
    }

    public BytesReader next(byte target) {
        while (this.read() == target) {
        }
        --this.cursor;
        return this;
    }

    public BytesReader skip(int length) {
        this.cursor += length;
        return this;
    }

    public boolean readable(int length) {
        return this.readable() >= length;
    }

    public byte readUnsafe() {
        return this.bytes.length > this.cursor ? this.bytes[this.cursor++] : (byte)-1;
    }

    public int read() {
        return this.readUnsafe() & 0xFF;
    }

    public BytesReader reset() {
        this.cursor = 0;
        this.flag = 0;
        return this;
    }

    public BytesReader reset(byte[] newBytes) {
        this.bytes = newBytes;
        return this.reset();
    }

    public BytesReader back(int range) {
        this.cursor -= range;
        return this;
    }

    public BytesReader back() {
        this.cursor = this.flag;
        return this;
    }

    public byte[] all() {
        return this.read(this.bytes.length - this.cursor);
    }

    public byte[] non() {
        return BytesUtil.EMPTY;
    }

    public int flag() {
        this.flag = this.cursor;
        return this.flag;
    }

    public int readable() {
        return this.bytes.length - this.cursor;
    }

    public int length() {
        return this.bytes.length;
    }
}

