/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.annuus.util.bytes;

public class BytesUtil {
    public static final byte[] EMPTY = new byte[0];

    public static void xor(byte[] target, byte[] xor) {
        for (int i = 0; i < target.length; ++i) {
            int n = i;
            target[n] = (byte)(target[n] ^ xor[i]);
        }
    }

    public static void reverse(byte[] bytes) {
        int end = bytes.length - 1;
        for (int start = 0; start < end; ++start) {
            int n = end;
            bytes[n] = (byte)(bytes[n] ^ bytes[start]);
            int n2 = start;
            bytes[n2] = (byte)(bytes[n2] ^ bytes[end]);
            int n3 = end--;
            bytes[n3] = (byte)(bytes[n3] ^ bytes[start]);
        }
    }

    public static byte[] reverseRound(byte[] source, int round) {
        byte[] result = new byte[round];
        int length = source.length;
        System.arraycopy(source, 0, result, round - length, length);
        return result;
    }

    public static byte[] skp(byte[] bytes, byte target) {
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == target) continue;
            byte[] result = new byte[bytes.length - i];
            System.arraycopy(bytes, i, result, 0, result.length);
            return result;
        }
        return new byte[0];
    }

    public static void skd(byte[] bytes, byte target) {
        BytesUtil.skd(bytes, target, (byte)0);
    }

    public static void skd(byte[] bytes, byte target, byte fill) {
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == target) continue;
            for (int i1 = 0; i1 < bytes.length; ++i1) {
                bytes[i1] = i < bytes.length ? bytes[i++] : fill;
            }
        }
    }

    public static byte[] concat(byte[] ... arrays) {
        int length = 0;
        for (byte[] array : arrays) {
            length += array.length;
        }
        byte[] result = new byte[length];
        int cur = 0;
        for (byte[] array : arrays) {
            if (array.length == 0) continue;
            System.arraycopy(array, 0, result, cur, array.length);
            cur += array.length;
        }
        return result;
    }

    public static byte[] array(byte ... bytes) {
        return bytes;
    }

    public static byte[] array(int ... bytes) {
        byte[] result = new byte[bytes.length];
        int index = 0;
        for (int i : bytes) {
            result[index++] = (byte)i;
        }
        return result;
    }

    public static byte setOne(byte b, int index) {
        return (byte)(b | (byte)(1 << index));
    }

    public static byte setZero(byte b, int index) {
        return (byte)(b & (byte)(~(1 << index)));
    }

    public static byte setReverse(byte b, int index) {
        return (byte)(b ^ (byte)(1 << index));
    }

    public static byte getBit(byte b, int index) {
        return (byte)(b >> index & 1);
    }
}

