/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.annuus.util.compress;

import com.github.cao.awa.annuus.information.compressor.InformationCompressor;
import com.github.cao.awa.annuus.information.compressor.InformationCompressors;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class AnnuusCompressUtil {
    public static void compress(FriendlyByteBuf buf, FriendlyByteBuf delegate, Supplier<InformationCompressor> compressorSupplier) {
        byte[] bytes = new byte[delegate.readableBytes()];
        delegate.readBytes(bytes);
        InformationCompressor compressor = compressorSupplier.get();
        buf.writeVarInt(compressor.getId());
        byte[] data = compressor.compress(bytes);
        buf.writeVarInt(data.length);
        buf.writeBytes(data);
    }

    public static FriendlyByteBuf decompress(FriendlyByteBuf buf) {
        int compressorId = buf.readVarInt();
        int packetSize = buf.readVarInt();
        byte[] data = new byte[packetSize];
        buf.readBytes(data);
        data = InformationCompressors.getCompressor(compressorId).decompress(data);
        return new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])data));
    }

    public static RegistryFriendlyByteBuf decompressRegistryBuf(RegistryFriendlyByteBuf buf) {
        return new RegistryFriendlyByteBuf((ByteBuf)AnnuusCompressUtil.decompress((FriendlyByteBuf)buf), buf.registryAccess());
    }
}

