/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.annuus.version.storage;

import com.github.cao.awa.annuus.map.expire.ExpiringMap;
import com.github.cao.awa.annuus.network.packet.client.update.NoticeUpdateServerAnnuusPayload;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;

public class AnnuusVersionStorage {
    private final ExpiringMap<Connection, Integer> versions = ExpiringMap.createFrom(Connection.class, Integer.class).enableExpiration().setExpiration(2L, TimeUnit.HOURS).whenExpiration((connection, value) -> {
        if (connection.isConnected()) {
            AnnuusVersionStorage.noticeUpdateAnnuusVersion(connection);
        }
    });

    public int getAnnuusVersion(Connection target) {
        return this.versions.getOrDefault(target, -1);
    }

    public int setAnnuusVersion(Connection target, int version) {
        this.versions.put(target, version);
        return version;
    }

    public static void noticeUpdateAnnuusVersion(Connection connection) {
        connection.send((Packet)NoticeUpdateServerAnnuusPayload.createPacket());
    }

    public static void noticeUpdateAnnuusVersion(ServerCommonPacketListenerImpl networkHandler) {
        networkHandler.send((Packet)NoticeUpdateServerAnnuusPayload.createPacket(), null);
    }
}

