/*
 * Decompiled with CFR 0.152.
 */
package com.fyxeinc.ffbandage.item;

import com.fyxeinc.ffbandage.Config;
import java.util.Random;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class FFBandageItem
extends Item {
    public FFBandageItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        Random random = new Random();
        int min = (Integer)Config.HEAL_AMOUNT_MIN.get();
        int max = (Integer)Config.HEAL_AMOUNT_MAX.get();
        int healAmount = random.nextInt(max - min + 1) + min;
        if (!level.isClientSide()) {
            livingEntity.heal((float)healAmount);
            boolean shouldShrink = true;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                boolean bl = shouldShrink = !serverPlayer.isCreative();
            }
            if (shouldShrink) {
                stack.shrink(1);
            }
        }
        return stack;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.EAT;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return (Integer)Config.HEAL_DURATION.get();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        player.startUsingItem(usedHand);
        return InteractionResultHolder.success((Object)stack);
    }
}

