/*
 * Decompiled with CFR 0.152.
 */
package net.chippymoo.creategolemsgalore;

import com.mojang.logging.LogUtils;
import net.chippymoo.creategolemsgalore.Config;
import net.chippymoo.creategolemsgalore.block.ModBlocks;
import net.chippymoo.creategolemsgalore.entity.ModEntities;
import net.chippymoo.creategolemsgalore.entity.client.AndesiteGolemRenderer;
import net.chippymoo.creategolemsgalore.entity.client.BrassedAndesiteGolemRenderer;
import net.chippymoo.creategolemsgalore.item.ModCreativeModTabs;
import net.chippymoo.creategolemsgalore.item.ModItems;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.item.CreativeModeTabs;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="creategolemsgalore")
public class CreateGolemsGalore {
    public static final String MOD_ID = "creategolemsgalore";
    private static final Logger LOGGER = LogUtils.getLogger();

    public CreateGolemsGalore(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        ModCreativeModTabs.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModEntities.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept(ModItems.COPPER_CALIBRATOR);
        }
        if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
            event.accept(ModBlocks.INDUSTRIAL_IRON_HAT);
            event.accept(ModBlocks.INDUSTRIAL_BRASS_HAT);
            event.accept(ModBlocks.INDUSTRIAL_BRASS_BLOCK);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @EventBusSubscriber(modid="creategolemsgalore", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.register(ModEntities.ANDESITEGOLEM.get(), AndesiteGolemRenderer::new);
            EntityRenderers.register(ModEntities.BRASSEDANDESITEGOLEM.get(), BrassedAndesiteGolemRenderer::new);
        }
    }
}

