/*
 * Decompiled with CFR 0.152.
 */
package net.chippymoo.creategolemsgalore.block;

import java.util.function.Supplier;
import net.chippymoo.creategolemsgalore.block.custom.BrassHatBlock;
import net.chippymoo.creategolemsgalore.block.custom.HatBlock;
import net.chippymoo.creategolemsgalore.block.custom.IndustrialBrassBlock;
import net.chippymoo.creategolemsgalore.item.ModItems;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"creategolemsgalore");
    public static final DeferredBlock<Block> INDUSTRIAL_IRON_HAT = ModBlocks.registerBlock("industrial_iron_hat", () -> new HatBlock(BlockBehaviour.Properties.of().noOcclusion().strength(4.0f).requiresCorrectToolForDrops().sound(SoundType.ANVIL)));
    public static final DeferredBlock<Block> INDUSTRIAL_BRASS_HAT = ModBlocks.registerBlock("industrial_brass_hat", () -> new BrassHatBlock(BlockBehaviour.Properties.of().noOcclusion().strength(4.0f).requiresCorrectToolForDrops().sound(SoundType.HEAVY_CORE)));
    public static final DeferredBlock<Block> INDUSTRIAL_BRASS_BLOCK = ModBlocks.registerBlock("industrial_brass_block", () -> new IndustrialBrassBlock(BlockBehaviour.Properties.of().noOcclusion().strength(3.0f).requiresCorrectToolForDrops().sound(SoundType.HEAVY_CORE)));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

