/*
 * Decompiled with CFR 0.152.
 */
package net.chippymoo.creategolemsgalore.block.custom;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.AllBlocks;
import java.util.function.Predicate;
import net.chippymoo.creategolemsgalore.entity.ModEntities;
import net.chippymoo.creategolemsgalore.entity.custom.BrassedAndesiteGolem;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BrassHatBlock
extends HorizontalDirectionalBlock {
    private BlockPattern golemPattern;
    public static final MapCodec<BrassHatBlock> CODEC = BrassHatBlock.simpleCodec(BrassHatBlock::new);

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        this.trySpawnCustomGolem(level, pos);
    }

    private void trySpawnCustomGolem(Level level, BlockPos pos) {
        BlockPattern.BlockPatternMatch match;
        if (this.golemPattern == null) {
            this.golemPattern = BlockPatternBuilder.start().aisle(new String[]{"~"}).aisle(new String[]{"#"}).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)((Block)AllBlocks.ANDESITE_ALLOY_BLOCK.get())))).where('~', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)this))).build();
        }
        if ((match = this.golemPattern.find((LevelReader)level, pos)) != null) {
            for (int y = 0; y < this.golemPattern.getHeight(); ++y) {
                for (int x = 0; x < this.golemPattern.getWidth(); ++x) {
                    for (int z = 0; z < this.golemPattern.getDepth(); ++z) {
                        BlockInWorld part = match.getBlock(x, y, z);
                        if (part == null) continue;
                        level.setBlock(part.getPos(), Blocks.AIR.defaultBlockState(), 3);
                    }
                }
            }
            BlockPos spawnPos = match.getBlock(0, 0, 0).getPos();
            BrassedAndesiteGolem golem = (BrassedAndesiteGolem)ModEntities.BRASSEDANDESITEGOLEM.get().create(level);
            if (golem != null) {
                golem.moveTo((double)spawnPos.getX() + 0.5, spawnPos.getY(), (double)spawnPos.getZ() + 0.5, 0.0f, 0.0f);
                level.addFreshEntity((Entity)golem);
            }
        }
    }

    public BrassHatBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }
}

