/*
 * Decompiled with CFR 0.152.
 */
package net.chippymoo.creategolemsgalore.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.chippymoo.creategolemsgalore.entity.client.AndesiteGolemAnimations;
import net.chippymoo.creategolemsgalore.entity.custom.BrassedAndesiteGolem;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class BrassedAndesiteGolemModel<T extends BrassedAndesiteGolem>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"creategolemsgalore", (String)"andesite_golem"), "main");
    private final ModelPart Golem;
    private final ModelPart Body;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart Pressarm;
    private final ModelPart rightleg;
    private final ModelPart leftleg;
    private final ModelPart face;
    private final ModelPart nose;
    private final ModelPart Hat;

    public BrassedAndesiteGolemModel(ModelPart root) {
        this.Golem = root.getChild("Golem");
        this.Body = this.Golem.getChild("Body");
        this.leftarm = this.Body.getChild("leftarm");
        this.rightarm = this.Body.getChild("rightarm");
        this.Pressarm = this.rightarm.getChild("Pressarm");
        this.rightleg = this.Body.getChild("rightleg");
        this.leftleg = this.Body.getChild("leftleg");
        this.face = this.Body.getChild("face");
        this.nose = this.face.getChild("nose");
        this.Hat = this.face.getChild("Hat");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Golem = partdefinition.addOrReplaceChild("Golem", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition Body = Golem.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(46, 39).addBox(-5.4981f, 7.9564f, -4.5009f, 13.0f, 13.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)-30.0f, (float)0.0f));
        PartDefinition leftarm = Body.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(0, 58).addBox(-0.5f, -3.0f, -2.5f, 1.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 58).addBox(0.5f, -3.0f, -2.5f, 6.0f, 17.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0019f, (float)11.9564f, (float)-1.001f));
        PartDefinition rightarm = Body.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(24, 60).addBox(-6.5f, -2.0f, -2.5f, 6.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 58).addBox(-0.5f, -2.0f, -2.5f, 1.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.9981f, (float)10.9564f, (float)-1.001f));
        PartDefinition Pressarm = rightarm.addOrReplaceChild("Pressarm", CubeListBuilder.create().texOffs(72, 60).addBox(-13.5f, 16.0f, -4.5f, 1.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(72, 60).addBox(-6.5f, 16.0f, -4.5f, 1.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(68, 15).addBox(-13.5f, 16.0f, -5.5f, 8.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(60, 35).addBox(-13.5f, 16.0f, 1.5f, 8.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(60, 18).addBox(-13.5f, 19.0f, -5.5f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)-11.0f, (float)2.0f));
        PartDefinition rightleg = Body.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(48, 60).addBox(-2.5f, 0.0f, -2.5f, 6.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.9981f, (float)20.9564f, (float)-1.001f));
        PartDefinition leftleg = Body.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(68, 0).addBox(-3.5f, 0.0f, -3.5f, 6.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0019f, (float)20.9564f, (float)-9.0E-4f));
        PartDefinition face = Body.addOrReplaceChild("face", CubeListBuilder.create().texOffs(0, 18).addBox(-7.5f, 0.0f, -8.0f, 17.0f, 8.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0019f, (float)-0.0436f, (float)0.999f));
        PartDefinition nose = face.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(36, 39).addBox(-1.5f, -1.0f, -1.0f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)5.0f, (float)-9.0f));
        PartDefinition Hat = face.addOrReplaceChild("Hat", CubeListBuilder.create().texOffs(0, 0).addBox(-8.5f, -3.0f, -9.0f, 19.0f, 3.0f, 15.0f, new CubeDeformation(0.0f)).texOffs(0, 39).addBox(-5.5f, -12.0f, -6.5f, 13.0f, 9.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.0019f, (float)0.0436f, (float)0.001f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(BrassedAndesiteGolem entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch);
        if (entity.isPressing()) {
            this.animate(entity.pressingAnimationState, AndesiteGolemAnimations.ANDESITEGOLEM_PRESS_ANIM, ageInTicks, 1.0f);
        } else {
            this.animateWalk(AndesiteGolemAnimations.ANDESITEGOLEM_WALK_ANIM, limbSwing, limbSwingAmount, 2.0f, 2.5f);
            this.animate(entity.idleAnimationState, AndesiteGolemAnimations.ANDESITEGOLEM_IDLE_ANIM, ageInTicks, 1.0f);
        }
    }

    private void applyHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.face.yRot = headYaw * ((float)Math.PI / 180);
        this.face.xRot = headPitch * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.Golem.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.Golem;
    }
}

