/*
 * Decompiled with CFR 0.152.
 */
package net.chippymoo.creategolemsgalore.entity.custom;

import com.simibubi.create.AllItems;
import net.chippymoo.creategolemsgalore.entity.AndesiteGolemVariants;
import net.chippymoo.creategolemsgalore.goals.AndesiteGolemPress;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class AndesiteGolem
extends Animal {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState pressingAnimationState = new AnimationState();
    public boolean isWrenchLocked = false;
    private int pressingTimer = 0;
    private boolean isFrozen = false;
    private PressAction pressCallback;
    private static final int ANIMATION_LENGTH = 40;
    private static final int IMPACT_TICK = 27;
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(AndesiteGolem.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_PRESSING = SynchedEntityData.defineId(AndesiteGolem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public AndesiteGolem(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.goalSelector.addGoal(2, (Goal)new AndesiteGolemPress(this, 1.5));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, stack -> stack.is((Holder)AllItems.ANDESITE_ALLOY), false));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.KNOCKBACK_RESISTANCE, 2.0).add(Attributes.MOVEMENT_SPEED, 0.1).add(Attributes.FOLLOW_RANGE, 24.0);
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob partner) {
        return null;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() == AllItems.WRENCH.get()) {
            if (!this.level().isClientSide) {
                if (this.isWrenchLocked) {
                    player.displayClientMessage((Component)Component.literal((String)"Golem Unlocked!"), true);
                    this.isWrenchLocked = false;
                } else {
                    player.displayClientMessage((Component)Component.literal((String)"Golem Locked!"), true);
                    this.isWrenchLocked = true;
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    public void setPressCallback(PressAction callback) {
        this.pressCallback = callback;
    }

    public boolean isPressing() {
        return (Boolean)this.entityData.get(DATA_PRESSING);
    }

    public void setPressing(boolean pressing) {
        this.entityData.set(DATA_PRESSING, (Object)pressing);
    }

    public void setFrozen(boolean frozen) {
        this.isFrozen = frozen;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_PRESSING, (Object)false);
        builder.define(VARIANT, (Object)0);
    }

    public void handleEntityEvent(byte id) {
        if (id == 11) {
            this.pressingAnimationState.start(this.tickCount);
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void startPressAnimation() {
        if (this.isPressing()) {
            return;
        }
        this.setPressing(true);
        this.setFrozen(true);
        this.pressingTimer = 40;
        if (this.getNavigation().isInProgress()) {
            this.getNavigation().stop();
        }
        if (this.level().isClientSide) {
            this.pressingAnimationState.start(this.tickCount);
            this.pressingAnimationState.animateWhen(true, this.tickCount);
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)11);
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide && this.isPressing()) {
            this.pressingAnimationState.animateWhen(true, this.tickCount);
        }
        if (!this.level().isClientSide && this.isPressing()) {
            --this.pressingTimer;
            if (this.pressingTimer == 13) {
                this.level().playSound(null, this.blockPosition(), SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    server.sendParticles((ParticleOptions)ParticleTypes.CRIT, this.getX(), this.getY() + 1.0, this.getZ(), 5, 0.2, 0.2, 0.2, 0.01);
                }
                if (this.pressCallback != null) {
                    this.pressCallback.onImpact();
                }
            }
            if (this.pressingTimer <= 0) {
                this.setPressing(false);
                this.setFrozen(false);
                this.pressCallback = null;
            }
        }
    }

    private int getTypeVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public AndesiteGolemVariants getVariant() {
        return AndesiteGolemVariants.byId(this.getTypeVariant() & 0xFF);
    }

    private void setVariant(AndesiteGolemVariants variant) {
        this.entityData.set(VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Variant", this.getTypeVariant());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(VARIANT, (Object)compound.getInt("Variant"));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        AndesiteGolemVariants variant = (AndesiteGolemVariants)((Object)Util.getRandom((Object[])AndesiteGolemVariants.values(), (RandomSource)this.random));
        this.setVariant(variant);
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public static interface PressAction {
        public void onImpact();
    }
}

