/*
 * Decompiled with CFR 0.152.
 */
package net.chippymoo.creategolemsgalore.goals;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.press.PressingRecipe;
import com.simibubi.create.content.logistics.depot.DepotBlockEntity;
import java.util.EnumSet;
import java.util.Optional;
import net.chippymoo.creategolemsgalore.entity.custom.AndesiteGolem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class AndesiteGolemPress
extends Goal {
    private final AndesiteGolem golem;
    private final double speed;
    private BlockPos targetDepot;

    public AndesiteGolemPress(AndesiteGolem golem, double speed) {
        this.golem = golem;
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.golem.isWrenchLocked) {
            return false;
        }
        Level level = this.golem.level();
        BlockPos golemPos = this.golem.blockPosition();
        int radius = 8;
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)golemPos.offset(-radius, -2, -radius), (BlockPos)golemPos.offset(radius, 2, radius))) {
            DepotBlockEntity depot;
            ItemStack item;
            BlockEntity blockEntity;
            if (!level.getBlockState(pos).is((Block)AllBlocks.DEPOT.get()) || !((blockEntity = level.getBlockEntity(pos)) instanceof DepotBlockEntity) || (item = (depot = (DepotBlockEntity)blockEntity).getHeldItem()).isEmpty() || !this.isPressable(item, level)) continue;
            this.targetDepot = pos.immutable();
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (this.golem.isWrenchLocked) {
            return false;
        }
        if (this.targetDepot == null) {
            return false;
        }
        BlockEntity blockEntity = this.golem.level().getBlockEntity(this.targetDepot);
        if (!(blockEntity instanceof DepotBlockEntity)) {
            return false;
        }
        DepotBlockEntity depot = (DepotBlockEntity)blockEntity;
        ItemStack stack = depot.getHeldItem();
        if (stack.isEmpty() || !this.isPressable(stack, this.golem.level())) {
            return false;
        }
        return this.golem.isPressing() || !this.golem.blockPosition().closerThan((Vec3i)this.targetDepot, 2.5);
    }

    public void start() {
        if (this.targetDepot != null) {
            Vec3 depotCenter = Vec3.atCenterOf((Vec3i)this.targetDepot);
            this.golem.getNavigation().moveTo(depotCenter.x, depotCenter.y, depotCenter.z, this.speed);
        }
    }

    public void tick() {
        if (this.targetDepot == null) {
            return;
        }
        Level level = this.golem.level();
        BlockEntity blockEntity = level.getBlockEntity(this.targetDepot);
        if (!(blockEntity instanceof DepotBlockEntity)) {
            this.stopPressing();
            return;
        }
        DepotBlockEntity depot = (DepotBlockEntity)blockEntity;
        ItemStack stack = depot.getHeldItem();
        if (stack.isEmpty() || !this.isPressable(stack, level)) {
            this.stopPressing();
            return;
        }
        Vec3 depotCenter = Vec3.atCenterOf((Vec3i)this.targetDepot);
        double distSq = this.golem.distanceToSqr(depotCenter);
        if (distSq > 2.25) {
            if (this.golem.getNavigation().isDone() && !this.golem.isFrozen()) {
                this.golem.getNavigation().moveTo(depotCenter.x, depotCenter.y, depotCenter.z, this.speed);
            }
            return;
        }
        this.golem.getLookControl().setLookAt(depotCenter.x, depotCenter.y + 0.5, depotCenter.z);
        if (!this.golem.isPressing()) {
            this.golem.setPressCallback(() -> AndesiteGolemPress.pressDepot(this.targetDepot, this.golem));
            this.golem.startPressAnimation();
        }
    }

    public void stop() {
        this.stopPressing();
    }

    private void stopPressing() {
        this.golem.setPressing(false);
        this.golem.setFrozen(false);
        this.targetDepot = null;
    }

    private boolean isPressable(ItemStack stack, Level level) {
        SingleRecipeInput input = new SingleRecipeInput(stack.copy());
        Optional maybe = level.getRecipeManager().getRecipeFor(AllRecipeTypes.PRESSING.getType(), (RecipeInput)input, level);
        return maybe.isPresent();
    }

    public static void pressDepot(BlockPos pos, AndesiteGolem golem) {
        Level level = golem.level();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof DepotBlockEntity)) {
            return;
        }
        DepotBlockEntity depot = (DepotBlockEntity)blockEntity;
        ItemStack input = depot.getHeldItem();
        if (input.isEmpty()) {
            return;
        }
        SingleRecipeInput recipeInput = new SingleRecipeInput(input.copy());
        Optional maybe = level.getRecipeManager().getRecipeFor(AllRecipeTypes.PRESSING.getType(), (RecipeInput)recipeInput, level);
        if (maybe.isEmpty()) {
            return;
        }
        PressingRecipe recipe = (PressingRecipe)((RecipeHolder)maybe.get()).value();
        ItemStack singleInput = input.copy();
        singleInput.setCount(1);
        ItemStack result = recipe.assemble((RecipeInput)new SingleRecipeInput(singleInput), (HolderLookup.Provider)level.registryAccess());
        if (result.isEmpty()) {
            return;
        }
        input.shrink(1);
        depot.setHeldItem(input);
        ItemStack currentOutput = depot.getHeldItem();
        if (input.isEmpty()) {
            depot.setHeldItem(result.copy());
        } else {
            ItemEntity outputEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.95, (double)pos.getZ() + 0.5, result.copy());
            outputEntity.setDeltaMovement(Vec3.ZERO);
            outputEntity.setPickUpDelay(10);
            level.addFreshEntity((Entity)outputEntity);
        }
        depot.setChanged();
        level.sendBlockUpdated(pos, depot.getBlockState(), depot.getBlockState(), 3);
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.playSound(null, pos, SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 0.7f, 1.0f);
            server.sendParticles((ParticleOptions)ParticleTypes.CRIT, (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 8, 0.1, 0.1, 0.1, 0.02);
        }
    }
}

