/*
 * Decompiled with CFR 0.152.
 */
package xyz.yoinky3000.server_info_api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.yoinky3000.server_info_api.api.APIRoute;
import xyz.yoinky3000.server_info_api.config.Players;
import xyz.yoinky3000.server_info_api.config.Settings;
import xyz.yoinky3000.server_info_api.handler.APIHandler;
import xyz.yoinky3000.server_info_api.handler.ConfigHandler;

public class ServerInfoAPI
implements ModInitializer {
    public static final String MOD_ID = "ServerInfoAPI";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ServerInfoAPI");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static MinecraftServer SERVER;
    public static ConfigHandler<Settings> config;
    public static ConfigHandler<Players> players;

    public void onInitialize() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            LOGGER.warn("Client environment detected \u2014 skipping mod initialization.");
            return;
        }
        LOGGER.info("Server Info API Starting!");
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            SERVER = server;
            LOGGER.info("Sever reference initialized");
        });
        config.load();
        players.load();
        try {
            APIHandler apiHandler = new APIHandler(ServerInfoAPI.config.getData().apiPort);
            apiHandler.registerInternalRoutes();
            apiHandler.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot start API server: " + String.valueOf(e));
        }
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.field_14140;
            UUID playerUuid = player.method_5667();
            String playerName = player.method_5477().getString();
            LOGGER.debug("Player {} (UUID: {}) joined, updating player list", (Object)playerName, (Object)playerUuid);
            players.getData().updateOrInsertPlayer(playerName, playerUuid);
            players.save();
        });
    }

    public static APIHandler.RegisterResult registerRoute(APIRoute route) {
        return APIHandler.registerRoute(route, false, false);
    }

    public static APIHandler.RegisterResult registerRoute(APIRoute route, boolean override) {
        return APIHandler.registerRoute(route, override, false);
    }

    public static APIHandler.RegisterResult registerRoute(String path, APIRoute route) {
        return APIHandler.registerRoute(path, route, false, false, false);
    }

    public static APIHandler.RegisterResult registerRoute(String path, APIRoute route, boolean override) {
        return APIHandler.registerRoute(path, route, false, override, false);
    }

    public static APIHandler.RegisterResult registerRoute(String path, APIRoute route, boolean requireMinecraftServer, boolean override) {
        return APIHandler.registerRoute(path, route, requireMinecraftServer, override, false);
    }

    static {
        config = new ConfigHandler<Settings>(Settings.class);
        players = new ConfigHandler<Players>(Players.class);
    }
}

