/*
 * Decompiled with CFR 0.152.
 */
package xyz.yoinky3000.server_info_api.api;

import java.util.HashMap;
import java.util.Map;

public class APIResponse {
    private final HttpStatus statusCode;
    private final MimeType mimeType;
    private final String body;

    public APIResponse(HttpStatus statusCode, MimeType mimeType, String body) {
        this.statusCode = statusCode;
        this.mimeType = mimeType;
        this.body = body;
    }

    public int getStatusCode() {
        return this.statusCode.getCode();
    }

    public String getMimeType() {
        return this.mimeType.getType();
    }

    public String getBody() {
        return this.body;
    }

    public static enum HttpStatus {
        OK(200),
        CREATED(201),
        NO_CONTENT(204),
        BAD_REQUEST(400),
        UNAUTHORIZED(401),
        FORBIDDEN(403),
        NOT_FOUND(404),
        METHOD_NOT_ALLOWED(405),
        INTERNAL_SERVER_ERROR(500),
        NOT_IMPLEMENTED(501),
        SERVICE_UNAVAILABLE(503);

        private final int code;
        private static final Map<Integer, HttpStatus> BY_CODE;

        private HttpStatus(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static HttpStatus fromCode(int code) {
            HttpStatus status = BY_CODE.get(code);
            if (status == null) {
                throw new IllegalArgumentException("No HttpStatus constant for code: " + code);
            }
            return status;
        }

        static {
            BY_CODE = new HashMap<Integer, HttpStatus>();
            for (HttpStatus status : HttpStatus.values()) {
                BY_CODE.put(status.code, status);
            }
        }
    }

    public static enum MimeType {
        TEXT_PLAIN("text/plain"),
        APPLICATION_JSON("application/json"),
        TEXT_HTML("text/html"),
        APPLICATION_XML("application/xml"),
        IMAGE_JPEG("image/jpeg");

        private final String type;

        private MimeType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

