/*
 * Decompiled with CFR 0.152.
 */
package xyz.yoinky3000.server_info_api.api.routes;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.server.MinecraftServer;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;

class ServerStats {
    private static final SystemInfo systemInfo = new SystemInfo();
    private static final CentralProcessor processor = systemInfo.getHardware().getProcessor();
    private static final GlobalMemory memory = systemInfo.getHardware().getMemory();

    ServerStats() {
    }

    public static Map<String, Object> collect(MinecraftServer server) {
        Map<String, Object> data = ServerStats.collect();
        Path serverDir = server.method_3831().toFile().toPath();
        long serverSizeBytes = ServerStats.getFolderSize(serverDir);
        long serverSizeMB = serverSizeBytes / 0x100000L;
        Map diskData = (Map)data.get("disk");
        diskData.put("usedMB", serverSizeMB);
        int online = server.method_3760().method_14574();
        int max = server.method_3760().method_14592();
        data.put("players", Map.of("online", online, "max", max));
        return data;
    }

    public static Map<String, Object> collect() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        long[] prevTicks = processor.getSystemCpuLoadTicks();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        double cpuLoad = processor.getSystemCpuLoadBetweenTicks(prevTicks) * 100.0;
        HashMap<String, Double> cpuMap = new HashMap<String, Double>();
        cpuMap.put("usagePercent", cpuLoad);
        data.put("cpu", cpuMap);
        long totalMemory = memory.getTotal() / 0x100000L;
        long availableMemory = memory.getAvailable() / 0x100000L;
        long usedMemory = totalMemory - availableMemory;
        HashMap<String, Long> ramMap = new HashMap<String, Long>();
        ramMap.put("usedMB", usedMemory);
        ramMap.put("totalMB", totalMemory);
        data.put("ram", ramMap);
        File root = new File(".");
        long totalDisk = root.getTotalSpace() / 0x40000000L;
        long freeDisk = root.getFreeSpace() / 0x40000000L;
        HashMap<String, Object> diskMap = new HashMap<String, Object>();
        diskMap.put("freeGB", freeDisk);
        diskMap.put("totalGB", totalDisk);
        diskMap.put("usedMB", "Unknown");
        data.put("disk", diskMap);
        data.put("players", "Unknown");
        return data;
    }

    public static long getFolderSize(Path folderPath) {
        long l;
        block8: {
            Stream<Path> files = Files.walk(folderPath, new FileVisitOption[0]);
            try {
                l = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).mapToLong(path -> {
                    try {
                        return Files.size(path);
                    }
                    catch (IOException e) {
                        return 0L;
                    }
                }).sum();
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 0L;
                }
            }
            files.close();
        }
        return l;
    }
}

