/*
 * Decompiled with CFR 0.152.
 */
package xyz.yoinky3000.server_info_api.api.routes.player;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import xyz.yoinky3000.server_info_api.ServerInfoAPI;
import xyz.yoinky3000.server_info_api.annotations.RouteSettings;
import xyz.yoinky3000.server_info_api.api.APIRequest;
import xyz.yoinky3000.server_info_api.api.APIResponse;
import xyz.yoinky3000.server_info_api.api.APIRoute;
import xyz.yoinky3000.server_info_api.config.Players;

@RouteSettings(path="/player/:criteria", requireMinecraftServer=true)
public class PlayerIDRoute
implements APIRoute {
    @Override
    public APIResponse handle(APIRequest request, MinecraftServer server) {
        String criteria = request.routeParams().get("criteria");
        Optional<Players.Player> playerFind = ServerInfoAPI.players.getData().find(criteria);
        if (playerFind.isEmpty()) {
            return new APIResponse(APIResponse.HttpStatus.NOT_FOUND, APIResponse.MimeType.TEXT_PLAIN, "No player match with search criteria - " + criteria);
        }
        Players.Player playerData = playerFind.get();
        class_3222 playerEntity = server.method_3760().method_14602(playerData.uuid);
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("uuid", playerData.uuid);
        res.put("name", playerData.name);
        if (playerEntity == null) {
            res.put("online", false);
        } else {
            res.put("online", true);
            HashMap<String, Object> info = new HashMap<String, Object>();
            class_243 playerPos = playerEntity.method_19538();
            info.put("currentPos", Map.of("x", playerPos.field_1352, "y", playerPos.field_1351, "z", playerPos.field_1350));
            class_1923 playerChunkPos = playerEntity.method_31476();
            info.put("currentChunkPos", Map.of("x", playerChunkPos.field_9181, "z", playerChunkPos.field_9180));
            String dimensionKey = playerEntity.method_37908().method_27983().method_29177().toString();
            info.put("dimension", dimensionKey);
            res.put("info", info);
        }
        return new APIResponse(APIResponse.HttpStatus.OK, APIResponse.MimeType.APPLICATION_JSON, ServerInfoAPI.GSON.toJson(res));
    }
}

